(function($,angular){
    'use_strict';

    var injectParams = ['$filter', '$scope','LanguageService','OptionService','validVariables','$timeout','sms_max_chars','$window','phoneNumbers', 'Template','SMSService', 'Message', 'i18n'];

    var MainController = function ($filter, $scope, LanguageService,OptionService,validVariables,$timeout,sms_max_chars,$window,phoneNumbers,Template,SMSService, Message, i18n){


        var ctrl = this;

        ctrl.option = OptionService.get();

        ctrl.languageService = LanguageService;

        ctrl.languages = LanguageService.get();

        console.log(ctrl.languageService.get_current());

        ctrl.updateStatus = false;
        ctrl.testStatus = false;
        ctrl.variables = validVariables;
        ctrl.focusedTemplate = '';
        ctrl.lastElement = null;
        ctrl.sms_max_chars = sms_max_chars;
        ctrl.buy_more = false;
        ctrl.showbuy = false;

        //Lock down system & bulk send!
        ctrl.lockDown = false;
        ctrl.numbersPerRequest = 100;
        ctrl.quepos = 0;
        ctrl.procentage = 0;
        ctrl.esitmatedTime = 0;
        ctrl.esitmatedMinutes = 0;
        ctrl.esitmatedSeconds = 0;
        ctrl.lastAjaxTime = 0;
        ctrl.usedCredits = 0;
        ctrl.loopCompleted = false;
        
        
        ctrl.sendSMSToAllTemplate = new Template({
            order_status : 'send_to_all',
            order_status_title : i18n.sendToAll,
            active : true,
            template : "",
            isfocus : false,
        });

        // Real numbers!
        ctrl.phoneNumbers = phoneNumbers.numbers;
        ctrl.countPhoneNumbers = phoneNumbers.count;
        ctrl.fromDate = new Date(phoneNumbers.date_from);
        ctrl.toDate = new Date(phoneNumbers.date_to); 
        ctrl.fetchingNumbers = false;
        ctrl.phoneText = i18n.fetchingCustomers;

        ctrl.setLanguage = function(language){
            ctrl.languageService.set_current(language);
            ctrl.changeFilter();
        };
        
        ctrl.blockAll = function(){
            
            if(ctrl.fetchingNumbers){
                ctrl.phoneText = i18n.fetchingCustomers;
            }else if(ctrl.countPhoneNumbers == 0){
                ctrl.phoneText = sprintf(i18n.couldNotFindBetween, $filter('date')(ctrl.fromDate, 'yyyy-MM-dd'), $filter('date')(ctrl.toDate, 'yyyy-MM-dd'));
            }else if(ctrl.option.credits == 0){
                ctrl.phoneText = i18n.noCreditsLeft;
            }

            if(ctrl.fetchingNumbers || ctrl.countPhoneNumbers == 0 || ctrl.option.credits == 0){
                return false;
            }

            return true;

        }

        ctrl.$onInit = function(){
            console.log("initiated");
            $scope.$watch('vm.fromDate', ctrl.changeFilter, true);
            $scope.$watch('vm.toDate', ctrl.changeFilter, true);
        };

        

        ctrl.getAvaliable = function(){
            return Math.floor(ctrl.option.credits / ctrl.sendSMSToAllTemplate.smsCreditsNeeded(1));
        }

        ctrl.changeFilter = function(val){

            if(($scope.optionForm.$invalid)){ return false; }

            ctrl.phoneNumbers = [];
            ctrl.fetchingNumbers = true;

            ctrl.countPhoneNumbers = 0;
            ctrl.blockAll();

            OptionService.getNewNumbers(ctrl.fromDate,ctrl.toDate).then(function(response){

                if(
                    angular.isObject(response.data) && 
                    angular.isDefined(response.data.success) && 
                    response.data.success == true &&
                    angular.isDefined(response.data.data) && 
                    angular.isObject(response.data.data)
                ){
                    var data = response.data.data;
                    ctrl.countPhoneNumbers = data.count;
                    ctrl.phoneNumbers = data.numbers;
                    ctrl.setDefualtValues();
                }

                ctrl.fetchingNumbers = false;


            }).catch(function(err){
                
                ctrl.fetchingNumbers = false;
            });

        }

        

        // ctrl.changeFilter();

        ctrl.saveOption = function(){

            if(($scope.optionForm.$invalid || !$scope.optionForm.$dirty) && !ctrl.updateStatus){
                return false;
            }

            ctrl.updateStatus = true;

            OptionService.save(ctrl.option).then(function(response){
                
                
                if(typeof response.data == 'object' && typeof response.data.success != 'undefined' && response.data.success == true){

                    ctrl.option.valid = response.data.data.option.isValid;                    
                    
                    new Message({
                        "msg" : i18n.settingsSaved,
                        "type" : "success"
                    });
                    ctrl.changeFilter();
                    

                }else{
                    new Message({
                        "msg" : i18n.settingsNotSaved,
                        "type" : "error"
                    });
                }

                ctrl.updateStatus = false;
                
                
                


            },function(error){
                ctrl.updateStatus = false;
                new Message({
                    "msg" : i18n.settingsNotSaved,
                    "type" : "error"
                });
            });

        };

        ctrl.isValid = function(){
            return ctrl.option.isValid();
        }

        ctrl.setDefualtValues = function(){

            $scope.optionForm.$setPristine();
            ctrl.updateStatus = false;

        }

        ctrl.addToTemplate = function($event,key){
            $event.preventDefault();
            $event.stopImmediatePropagation();
            
            if(ctrl.lastElement !== null){
                ctrl.lastElement.focus();
                $timeout(function(){
                    ctrl.focusedTemplate.template = ctrl.focusedTemplate.template + key;
                },0);
            }   
            
        }

        ctrl.addVariable = function(variable){
            if(ctrl.focusedTemplate.template == ""){
                ctrl.focusedTemplate.template = variable;
            }else{
                ctrl.focusedTemplate.template += " "  + variable;
            }
            
        }

        ctrl.buyMore = function(){
            $window.open(ctrl.option.getBuyLink());
        }

        ctrl.sendTest = function(){

            if(ctrl.focusedTemplate.template.length === 0){
                return false;
            }

            if(ctrl.focusedTemplate instanceof Template){
                ctrl.testStatus = true;

                SMSService.send_sms(ctrl.option.phone,ctrl.option.from,ctrl.focusedTemplate.compileTemplate()).then(function(response){

                    if(typeof response == 'object' && typeof response.success != 'undefined' && response.success == true){
                        ctrl.option.credits = response.data.credits;                    
                        ctrl.modifycredits(ctrl.option.credits);
                    }

                    ctrl.testStatus = false;
                });

            }

        }

        /**
         * Admin bar credits!
         */
        ctrl.modifycredits = function(credits){

            var e = angular.element(document.getElementById("credits"));
            if(e.length > 0){
                e[0].innerHTML = credits;
            }

        }


        ctrl.sendToAll = function(){

            var template = ctrl.sendSMSToAllTemplate;
            ctrl.lockDown = false;

            if(ctrl.countPhoneNumbers === 0){
                new Message({
                    msg : i18n.noCustomersWithNumbers,
                    type : 'error'
                });

                return false;
            }

            if(template.template.length === 0){
                return false;
            }

            var numbers = ctrl.getAvaliable();

            if(numbers < ctrl.sendSMSToAllTemplate.smsCreditsNeeded(ctrl.countPhoneNumbers)){
                ctrl.countPhoneNumbers = numbers;
                ctrl.phoneNumbers = ctrl.phoneNumbers.splice(0,numbers);
            }
            

            if(template instanceof Template && 
                confirm(sprintf(i18n.messageSendConfirm, template.smsCreditsNeeded(ctrl.countPhoneNumbers, ctrl.countPhoneNumbers)))){

                ctrl.lockDown = true;
                ctrl.numbersPerRequest = 100;
                ctrl.quepos = 0;
                ctrl.procentage = 0;
                ctrl.esitmatedTime = Math.ceil(ctrl.countPhoneNumbers / ctrl.numbersPerRequest) * 4;
                ctrl.esitmatedMinutes = Math.floor(ctrl.esitmatedTime / 60);
                ctrl.esitmatedSeconds = ctrl.esitmatedTime - (ctrl.esitmatedMinutes * 60);
                ctrl.lastAjaxTime = 0;
                ctrl.usedCredits = 0;
                ctrl.loopCompleted = false;

                ctrl.send_loop();

            }

        }

        

        
        ctrl.send_loop = function(){            

            var template = ctrl.sendSMSToAllTemplate;

            var timerStart = new Date().getTime() / 1000;
            var timerEnd = 0;
            
            if(ctrl.quepos >= ctrl.countPhoneNumbers){
                ctrl.procentage = 100;
                ctrl.loopCompleted = true;
                ctrl.changeFilter();
                return true;
            }

            var to = [];
            var from = ctrl.option.from;
            var template = template.compileTemplate();

            for(var i = 0; i<ctrl.numbersPerRequest; i++){
                var index = ctrl.quepos + i;
                if(typeof ctrl.phoneNumbers[ctrl.quepos + i] !== 'undefined'){
                    to.push(ctrl.phoneNumbers[ctrl.quepos + i]);
                }else{
                    ctrl.numbersPerRequest = i;
                }
            }

            SMSService.send_bulk_sms(to,from,template).then(function(response){

                if(typeof response == 'object' && typeof response.success != 'undefined' && response.success == true){
                    ctrl.usedCredits += response.data.used_credits;
                    ctrl.option.credits = response.data.credits;
                    ctrl.modifycredits(ctrl.option.credits);                 
                }


                ctrl.quepos += ctrl.numbersPerRequest;
                ctrl.procentage = Math.round((ctrl.quepos / ctrl.countPhoneNumbers) * 100);

                timerEnd = Math.round((new Date().getTime() / 1000) - timerStart);
                ctrl.esitmatedTime = Math.ceil((ctrl.countPhoneNumbers-ctrl.quepos) / ctrl.numbersPerRequest) * timerEnd;
                ctrl.esitmatedMinutes = Math.floor(ctrl.esitmatedTime / 60);
                ctrl.esitmatedSeconds = ctrl.esitmatedTime - (ctrl.esitmatedMinutes * 60);
                
                ctrl.send_loop();

            });
            

        };

        ctrl.closeLoop = function(){

            ctrl.setDefualtValues();
            ctrl.numbersPerRequest = 100;
            ctrl.quepos = 0;
            ctrl.procentage = 0;
            ctrl.esitmatedTime = Math.ceil(ctrl.countPhoneNumbers / ctrl.numbersPerRequest) * 4;
            ctrl.esitmatedMinutes = Math.floor(ctrl.esitmatedTime / 60);
            ctrl.esitmatedSeconds = ctrl.esitmatedTime - (ctrl.esitmatedMinutes * 60);
            ctrl.lastAjaxTime = 0;
            ctrl.usedCredits = 0;
            ctrl.loopCompleted = false;
            ctrl.lockDown = false;
            ctrl.blur();
            

        };

        ctrl.focus = function(_template,$event){

            var element = $($event.srcElement);
            
            ctrl.lastElement = element;
            ctrl.focusedTemplate = _template;
            _template.isfocus = true;

            var cellphone = $("body").find('div.cellphone').eq(0);
            var sidebar = $("body").find(".woo-sms div.sidebar").eq(0);

            var topPos = element.offset().top;
            var sidebarpos = sidebar.offset().top;
            var new_position = (topPos-sidebarpos) - 50;
            
            $("body").find('div.cellphone').css({
                "top" : new_position
            });

            $("html, body").animate({scrollTop:new_position},500);

        }

        ctrl.blur = function(){

            if(!ctrl.lockDown){

                ctrl.focusedTemplate.isfocus = false;
                ctrl.focusedTemplate = '';

            }
        }

        ctrl.reload = function(){
            $window.location.reload();
        }

        var addedEventListner = false;

        $scope.$watch('optionForm.$dirty',function(){
            
            if($scope.optionForm.$dirty){
                if(!addedEventListner){
                    window.addEventListener( 'beforeunload', areYouSurePrompt);
                    addedEventListner = true;
                }
            }else{
                addedEventListner = false;
                window.removeEventListener( 'beforeunload', areYouSurePrompt);
            }
        });


        


        function areYouSurePrompt(ev){
            return ev.returnValue = i18n.areYouSure;
        }

        return ctrl;

    };

    MainController.$inject = injectParams;

    angular.module('woo-sms').controller('MainController', MainController);

})(jQuery,angular);