(function(angular){
    'use_strict';

    var injectParams = ['$timeout'];

    var focusOnShow = function ($timeout) {
        return {
            restrict: 'A',
            link: function ($scope, $element, $attr) {
                if ($attr.ngShow) {
                    $scope.$watch($attr.ngShow, function (newValue) {
                        if (newValue) {
                            $timeout(function () {
                                $element[0].focus();
                            }, 100);
                        } 
                    })
                }
                if ($attr.ngHide) {
                    $scope.$watch($attr.ngHide, function (newValue) {
                        if (!newValue) {
                            $timeout(function () {
                                $element[0].focus();
                            }, 100);
                        }
                    })
                }

            }
        };
    }

    focusOnShow.$inject = injectParams;

    angular.module("woo-sms").directive('focusOnShow',focusOnShow);

})(angular);