(function($,angular){

    var injectParams = ['templateFolder'];

    var inputText = function(templateFolder){

        return {
            restrict : 'E',
            replace : true,
            transclude: true,
            scope : {
                ngModel: '=',
                label:'@',
                cssClass:'@',
                validate:'@',
                disabled:'@',
                required:'@',
                maxLength:'@',
                type:'@'
            },
            link: function(scope, element, attrs) {

                scope.cssClass = attrs.cssClass !== undefined ? attrs.cssClass : 'col-xs-12';
                scope.validateType = attrs.validate !== undefined ? attrs.validate : 'none';
                //scope.required = attrs.required == true ? true : false;

                if(angular.isUndefined(scope.type)){
                    scope.type='text';
                }

                
                scope.$watch(function(newValue,oldValue){
                    if(newValue.ngModel !== '' && newValue.ngModel !== undefined){
                        $(element).find('.fg-line').addClass('fg-toggled');
                    }else{
                        if(!$(element).find('input').is(':focus')){
                            $(element).find('.fg-line').removeClass('fg-toggled');
                        }
                    }
                });

            }, 
            templateUrl : templateFolder + "/directives/inputText.html"
        }
    };

    inputText.$inject = injectParams;

    angular.module('woo-sms').directive('inputText',inputText);

})(jQuery,angular); 