(function(angular){
    
    var injectParams = ['templateFolder','$timeout','$interval'];

    var theIframe = function(templateFolder,$timeout,$interval){


        var interval;

        return {
            restrict : 'E',
            scope : {
                option : '=option',
                load : '=load',
                showbuy:'=showbuy'
            },
            replace : true,
            templateUrl : templateFolder + '/directives/theIframe.html',
            link : function($scope,$element,$attr){

                $scope.$watch('load',function(loaded){

                    if(loaded){
                        $element.find('iframe').bind('load', function (event) {

                            $scope.showbuy = true;

                            
                            var frame = angular.element(this);
                            frame.css({
                                opacity:0
                            });
        
                            interval = $interval(function(){
        
                                var height = frame.contents().find('body').height();                     
        
                                frame.css({
                                    height : height,
                                    opacity : 1
                                });
        
                            },1000);
                            
                        });
                    }else{
                        
                        $scope.showbuy = false;

                        if(angular.isDefined(interval)){
                            $interval.cancel(interval);
                            interval = undefined;
                        }
                        
                    }

                });

                $scope.$on('$destroy',function(){

                    if(angular.isDefined(interval)){
                        $interval.cancel(interval);
                        interval = undefined;
                    }

                });

                

            }
        };

    }

    theIframe.$inject = injectParams;

    angular.module('woo-sms').directive('theIframe',theIframe);

})(angular); 