(function($,angular){

    function isValidDate(dateString) {
        
        var regEx = /^\d{4}-\d{2}-\d{2}$/;

        if(!dateString.match(regEx)) return false;  // Invalid format
        
        var d = new Date(dateString);
        if(!d.getTime() && d.getTime() !== 0) return false; // Invalid date
        return d.toISOString().slice(0,10) === dateString;
    }

    var validateIt = function(type, req, value, label, element){

        var result = {
            success : true,
            msg : sprintf(_woo_sms_gf.i18n.mustFill, label.toLowerCase())
        };

        //if not required and value is null return true
        if(!req && (value === '' || value === undefined)){

            if(type==="pwd"){
                angular.element($("input.pwdrepeat")).trigger("changed"); 
            }

            if(type === "pwdrepeat"){
                var pwd = $("input.pwd").val();
                if(pwd !== '' || pwd === undefined){
                    req = true;
                }

            }else{
                return result;
            }
        } 

        //if is required and value is null return false
        if(req && (value === '' || value === undefined)){
            result.success = false;
            return result;
        }

        

        switch(type){ 

            case "email" :
                if(!value.isEmail()){
                    result.msg = _woo_sms_gf.i18n.emailValidFail;
                    result.success = false;
                }
            break;
            case "number" :
                if(!value.isNumber()){
                    result.msg = _woo_sms_gf.i18n.numberValidFail;
                    result.success = false;
                }
            break;
            case "civic" :
                if(!value.isCivic()){
                    result.msg = _woo_sms_gf.i18n.socSecValidFail;
                    result.success = false;
                }
            break;

            case "date" :
                if(!isValidDate(value)){
                    result.msg = _woo_sms_gf.i18n.dateValidFail;
                    result.success = false;
                }
            break;

            case "pwd" :
                angular.element($("input.pwdrepeat")).trigger("changed"); 
                if(!value.isGoodPassword()){
                    result.msg = _woo_sms_gf.i18n.passLengthValidFail;
                    result.success = false;
                }
            break;
            case "pwdrepeat" :
                var v = $("input.pwd").val();
                //angular.element($("input.pwd")).trigger("changed"); 
                if(v !== value){
                    
                    result.msg = _woo_sms_gf.i18n.passValidFail;
                    result.success = false;
                }
            break;
            case "maxlength":
                var max = parseInt(element.attr('max-length'));
                if(value.length > max){
                    result.msg = sprintf(_woo_sms_gf.i18n.lengthValidFail, max);
                    result.success = false;
                }
            break;

        }

        return result;
    };


    var injectParams = [];

    var validateInput = function($sce){
        return{
            require: '?ngModel',
            link : function(scope, element, attrs, ngModel) {

                scope.ErrorMsg = "";
                scope.Valid = true;
                element.on('keyup blur changed',function(){
                    
                    var validationType = attrs.validateInput;

                    if(validationType !== "none" || scope.required){
                        var value = $(this).val();
                        var validated = validateIt(validationType,scope.required,value,scope.label,element);
                        if(!validated.success){ 
                            scope.ErrorMessage = validated.msg;
                            scope.Valid = false;
                            ngModel.$setValidity('required',false);
                            element.parent().addClass("invalid"); 
                        }else{
                            scope.Valid = true;
                            scope.ErrorMessage = "";
                            ngModel.$setValidity('required',true);
                            element.parent().removeClass("invalid");
                        }
                    }

                    scope.$apply();
                    
                });

                

            }
        };
    };

    validateInput.$inject = injectParams;
 
    angular.module('woo-sms').directive('validateInput',validateInput);
 
})(jQuery,angular); 