//import { sprintf } from "../utils/sprintf.util";

(function($,angular){
    'use_strict';

    var injectParams = ['Template','$sce','buy_url'];

    var Option = function(Template,$sce,buy_url){

        function Option(data){
            var s = this;

            s.credits = !!data.credits ? data.credits : '';
            s.first_name = !!data.first_name ? data.first_name : '';
            s.last_name = !!data.last_name ? data.last_name : '';
            s.company = !!data.company ? data.company : '';
            s.phone = !!data.phone ? data.phone : '';
            s.email = !!data.email ? data.email : '';
            s.license_key = !!data.license_key ? data.license_key : '';
            s.valid = !!data.isValid ? data.isValid : '';
            s.from = !!data.from ? data.from : '';
            s.blacklist = !!data.blacklist ? data.blacklist : '';
            s.templates = [];

            if(typeof data.templates == 'object' || typeof data.templates == 'array'){

                angular.forEach(data.templates,function(_template,index){
                    s.templates.push(new Template(_template));
                });

            }

            s.isValid = function(){

                return (
                    s.first_name != '' && 
                    s.last_name != '' &&
                    s.from != '' &&
                    s.phone != '' &&
                    s.email != '' &&
                    s.license_key != '' &&
                    s.valid
                ) ? true : false;

            }

            s.getBuyLink = function(){

                var url = sprintf(
                    '%s%s/?first_name=%s&last_name=%s&email=%s&phone=%s&company=%s',
                    buy_url,
                    s.license_key,
                    s.first_name,
                    s.last_name,
                    s.email,
                    s.phone,
                    s.company
                );

                return $sce.trustAsResourceUrl(url);
            };

            s.getSaveData = function(){

                var templates = [];

                angular.forEach(s.templates,function(_template,index){
                    templates.push(_template.getSaveData());
                });

                s.blacklist = s.blacklist.replace(/\s/g,'');

                if(s.blacklist != '' && s.blacklist.charAt(s.blacklist.length-1) !== ','){
                    s.blacklist = s.blacklist + ',';
                }

                return $.param({
                    credits      : s.credits,
                    first_name   : s.first_name,
                    last_name    : s.last_name,
                    company      : s.company,
                    from         : s.from,
                    phone        : s.phone,
                    email        : s.email,
                    license_key  : s.license_key,
                    templates    : templates,
                    blacklist    : s.blacklist,
                    action       : 'woo_sms_gf_update_options'
                });
            }

            return s;
        }

        return Option;
    }

    angular.module('woo-sms').factory('Option',Option);


})(jQuery,angular);