(function(angular){
    'use_strict';

    var injectParams = ["order_keys", "sms_max_chars"];

    var Template = function(order_keys,sms_max_chars){

        function Template(_template){

            var s = this;

            s.order_status = _template.order_status;
            s.order_status_title = _template.order_status_title;
            s.active = parseInt(_template.active) == 1 ? true : false;
            s.template = _template.template;
            s.language = _template.language;
            s.isfocus = false;

            s.activate = function(fTemplate){
                s.active = (parseInt(s.active) == 1 || s.active) ? false : true;

                if(s.active == false){
                    s.isfocus = false;
                }else{
                    s.isfocus = true;
                    fTemplate = s;
                }
            }

            s.compileTemplate = function(){

                var template = s.template;

                if(s.order_status !== 'send_to_all'){
                    angular.forEach(order_keys,function(k,i){
                        var reg = new RegExp( "{" +i + "}", "g" );
                        template = template.replace(reg, k);
                    });
                }

                return template == '' ? _woo_sms_gf.i18n.writeSomething : template;
            }

            

            s.smsCreditsNeeded = function(numbers){
                var t = s.compileTemplate().length;
                var smsLength = t == 0 ? 1 : t;
                return numbers * Math.ceil(smsLength / sms_max_chars);
            }

            s.getSaveData = function(){
                return {
                    order_status : s.order_status,
                    order_status_title : s.order_status_title,
                    active : s.active,
                    template : s.template,
                    language: s.language
                };
            }

            s.messageLength = function(msg){
                return s.compileTemplate().length;
            }

            return s;
        }

        return Template;
    }

    Template.$inject = injectParams;

    angular.module('woo-sms').factory('Template',Template);


})(angular);