(function ($, angular) {
    'use_strict';

    var injectParams = ['is_wpml_active', 'Language'];

    var LanguageService = function (is_wpml_active, Language) {

        var s = this;

        s.object = _woo_sms_gf;

        s.current_code = 'default';

        s.current_language = null;

        s.languages = [];

        s.is_active = function(){
            return is_wpml_active;
        };

        s.get = function(){

            if (!s.is_active()) return [];

            if(s.languages.length > 0) return s.languages;

            if(s.object.wpml_languages.length > 0){
                angular.forEach(s.object.wpml_languages, function(language){

                    var l = new Language(language);

                    if(l.current){
                        s.current_code = l.get_code();
                        s.current_language = l;
                    }

                    s.languages.push(l);

                });
            }

            return s.languages;

        };

        s.get_current_code = function(){
            return s.get_current().code;
        };

        s.get_current = function(){
            return s.current_language;
        };

        s.set_current = function(l){

            angular.forEach(s.languages, function(language){
                language.current = false;
            });

            s.current_code = l.get_code();
            s.current_language = l;
            l.current = true;

        };

        return s;

    };

    LanguageService.$inject = injectParams;

    angular.module('woo-sms').factory('LanguageService', LanguageService);



    angular.module('woo-sms').filter('languageFilter', ['LanguageService', function (LanguageService){
        
        function lFilter(_items){

            var items = [];

            angular.forEach(_items, function(item){
                if (item.language == LanguageService.current_code){
                    items.push(item);
                }
            });
            
            return items;
        }

        return lFilter;

    }]);


})(jQuery, angular); 