(function($,angular){
    'use_strict';

    var injectParams = ['$http', 'Option', 'LanguageService'];

    var OptionService = function ($http, Option, LanguageService){

        var s = this;
        
        s.object = _woo_sms_gf;
        s.LanguageService = LanguageService;

        s.get = function(){
            return new Option(s.object.options);
        };

        s.save = function(option){
            
            return $http({
                url : s.object.ajax_url,
                method : 'post',
                data : option.getSaveData(),
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8'
               }
            });

        };

        /**
         * Format date
         * 
         * @param {Date} dateObj
         */
        s.formatDate = function(dateObj){

            var dd = dateObj.getDate();
            var mm = dateObj.getMonth() + 1; //January is 0!

            var yyyy = dateObj.getFullYear();
            if (dd < 10) {
                dd = '0' + dd;
            }
            if (mm < 10) {
                mm = '0' + mm;
            }

            return yyyy + '-' + mm + '-' + dd;
            
        };

        s.getNewNumbers = function(date1,date2){

            var language = null;

            if (s.LanguageService.is_active()){
                language = s.LanguageService.get_current_code();
            }

            var new_date1 = s.formatDate(new Date(date1));
            var new_date2 = s.formatDate(new Date(date2));

            var data = $.param({
                from_date: new_date1,
                to_date: new_date2,
                language: language,
                action : 'woo_sms_gf_get_phone_numbers'
            });

            return $http({
                url : s.object.ajax_url,
                method : 'post',
                data : data,
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8'
                }
            });


        }

        return s;

    };

    OptionService.$inject = injectParams;

    angular.module('woo-sms').factory('OptionService',OptionService);

})(jQuery,angular);