(function($,angular){
    'use_strict';

    var injectParams = ['$http', 'Message', '$timeout','LanguageService'];

    var SMSService = function ($http, Message, $timeout, LanguageService){

        var s = this;
        
        s.object = _woo_sms_gf;

        s.send_bulk_sms = function(to,from,message){

            var postData = $.param({
                action : 'woo_sms_gf_send_bulk_sms',
                to : to,
                from : from,
                message : message,
                language_code: LanguageService.current_code
            });
            
            return $http({
                url : s.object.ajax_url,
                method : 'post',
                data : postData,
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8'
               }
            }).then(function(success){
                return success.data;
            },function(error){
                //Do something
            });


        };

        s.send_sms = function(to, from, message){

            var postData = $.param({
                action : 'woo_sms_gf_send_sms',
                to : to,
                from : from,
                message : message
            });

            return $http({
                url : s.object.ajax_url,
                method : 'post',
                data : postData,
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8'
               }
            }).then(function(success){
                
                new Message({
                    msg : sprintf(s.object.i18n.sentTo, to),
                    type : 'success'
                });

                return success.data;

            },function(error){
                
                new Message({
                    msg : sprintf(s.object.i18n.couldNotSend, to),
                    type : 'error'
                });

            });


        };

        return s;

    };

    SMSService.$inject = injectParams;

    angular.module('woo-sms').factory('SMSService',SMSService);

})(jQuery,angular);