(function(angular){

    var messageModule = angular.module("gfMessage",[]);

    var injectMessageParams = [ '$rootScope', '$compile', '$rootElement', '$timeout' ];

    var Message = function( $rootScope, $compile, $rootElement, $timeout ){

        var s = this;
        
        s.$scope = $rootScope.$new();
        s.$scope.messages = [];
        s.element = $compile('<gf-message></gf-message>')(s.$scope);

        $rootElement.append(s.element[0]);

        function Message( obj ){
            var m = this;            

            obj.id = guid();
            obj.timeout = typeof obj.timeout == 'undefined' ? 5000 : obj.timeout;
            obj.removeAfter = typeof obj.removeAfter == 'undefined' ? 500 : obj.removeAfter;
            obj.class = "in";
            s.$scope.messages.push(obj);

            $timeout(function(){
                var theIndex = 0;
                angular.forEach(s.$scope.messages,function(message, index){
                    if(message === obj){
                        theIndex = index;
                        message.class = "";
                    }
                });


                $timeout(function(){
                    s.$scope.messages.splice(theIndex,1);
                },obj.removeAfter);
                

            },obj.timeout);

        }

        function guid() {
            function s4() {
              return Math.floor((1 + Math.random()) * 0x10000)
                .toString(16)
                .substring(1);
            }
            return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
              s4() + '-' + s4() + s4() + s4();
          }
               

        return Message;
    };

    Message.$inject = injectMessageParams;
    messageModule.factory('Message',Message);

    var messageDirective = function(){

        var link = function( $scope, $el ){
            

            $scope.$watch('messages',function(messages){
                
            });
        };

        return {
            restrict : 'E',
            link : link,
            replace : true,
            template : '<div class="gf-message" ng-class="{in:messages.length>0}"><ul><li ng-repeat="message in messages" class="{{message.type}} {{message.class}}">{{message.msg}}</li></ul></div>'
        }

    };

    messageModule.directive('gfMessage',messageDirective);


})(angular);