(function(angular){

    var messageModule = angular.module("gfMessage",[]);

    var injectMessageParams = [ '$rootScope', '$compile', '$rootElement', '$timeout' ];

    var Message = function( $rootScope, $compile, $rootElement, $timeout ){

        var s = this;
        
        s.$scope = $rootScope.$new();
        s.$scope.messages = [];
        s.element = $compile('<gf-message></gf-message>')(s.$scope);

        $rootElement.append(s.element[0]);

        function Message( obj ){
            var m = this;            

            obj.id = guid();
            obj.timeout = typeof obj.timeout == 'undefined' ? 5000 : obj.timeout;
            obj.removeAfter = typeof obj.removeAfter == 'undefined' ? 500 : obj.removeAfter;
            obj.class = "in";
            s.$scope.messages.push(obj);

            $timeout(function(){
                var theIndex = 0;
                angular.forEach(s.$scope.messages,function(message, index){
                    if(message === obj){
                        theIndex = index;
                        message.class = "";
                    }
                });


                $timeout(function(){
                    s.$scope.messages.splice(theIndex,1);
                },obj.removeAfter);
                

            },obj.timeout);

        }

        function guid() {
            function s4() {
              return Math.floor((1 + Math.random()) * 0x10000)
                .toString(16)
                .substring(1);
            }
            return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
              s4() + '-' + s4() + s4() + s4();
          }
               

        return Message;
    };

    Message.$inject = injectMessageParams;
    messageModule.factory('Message',Message);

    var messageDirective = function(){

        var link = function( $scope, $el ){
            

            $scope.$watch('messages',function(messages){
                
            });
        };

        return {
            restrict : 'E',
            link : link,
            replace : true,
            template : '<div class="gf-message" ng-class="{in:messages.length>0}"><ul><li ng-repeat="message in messages" class="{{message.type}} {{message.class}}">{{message.msg}}</li></ul></div>'
        }

    };

    messageModule.directive('gfMessage',messageDirective);


})(angular);
(function(angular){
    'use_strict';

    angular.module("woo-sms",['ngSanitize','gfMessage']).config(function($sceDelegateProvider){
        $sceDelegateProvider.resourceUrlWhitelist([
            // Allow same origin resource loads.
            'self',
            // Allow loading from our assets domain.  Notice the difference between * and **.
            'http://localhost/woosmstest/**',
            'http://localhost:3000/woosmstest/**'
          ]);
    });

})(angular);
(function(angular){

    var config = _woo_sms_gf;
    
    angular.module('woo-sms').constant("templateFolder",config.folder);
    angular.module('woo-sms').constant("validVariables",config.valid_variables);
    angular.module('woo-sms').constant("order_keys",config.order_keys);
    angular.module('woo-sms').constant("sms_max_chars",config.sms_max_chars);
    angular.module('woo-sms').constant("buy_url",config.buy_url);
    angular.module('woo-sms').constant("phoneNumbers",_woo_sms_gf_numbers.n);
    angular.module('woo-sms').constant("is_wpml_active", config.wpml_active == "1" ? true : false);
    angular.module('woo-sms').constant('i18n', config.i18n);

})(angular);
//IsNumber function
String.prototype.isNumber = function () {
    return /^\d+$/.test(this);
};
//IsValidDate
String.prototype.isDate = function () {
    return /^\d{4}-\d{2}-\d{2}$/.test(this);
};

//IsCivic
String.prototype.isCivic = function () {
    return /^\d{12}$/.test(this);
};

//isStringEmail
String.prototype.isEmail = function () {
    return /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/.test(this);
};

//isAGoodPassword
String.prototype.isGoodPassword = function () {
    return /^(?=.*).{8,}$/.test(this);
};
/*! sprintf-js v1.1.1 | Copyright (c) 2007-present, Alexandru Mărășteanu <hello@alexei.ro> | BSD-3-Clause */
!function(){"use strict";function e(e){return r(n(e),arguments)}function t(t,r){return e.apply(null,[t].concat(r||[]))}function r(t,r){var n,i,a,o,p,c,u,f,l,d=1,g=t.length,b="";for(i=0;i<g;i++)if("string"==typeof t[i])b+=t[i];else if(Array.isArray(t[i])){if((o=t[i])[2])for(n=r[d],a=0;a<o[2].length;a++){if(!n.hasOwnProperty(o[2][a]))throw new Error(e('[sprintf] property "%s" does not exist',o[2][a]));n=n[o[2][a]]}else n=o[1]?r[o[1]]:r[d++];if(s.not_type.test(o[8])&&s.not_primitive.test(o[8])&&n instanceof Function&&(n=n()),s.numeric_arg.test(o[8])&&"number"!=typeof n&&isNaN(n))throw new TypeError(e("[sprintf] expecting number but found %T",n));switch(s.number.test(o[8])&&(f=n>=0),o[8]){case"b":n=parseInt(n,10).toString(2);break;case"c":n=String.fromCharCode(parseInt(n,10));break;case"d":case"i":n=parseInt(n,10);break;case"j":n=JSON.stringify(n,null,o[6]?parseInt(o[6]):0);break;case"e":n=o[7]?parseFloat(n).toExponential(o[7]):parseFloat(n).toExponential();break;case"f":n=o[7]?parseFloat(n).toFixed(o[7]):parseFloat(n);break;case"g":n=o[7]?String(Number(n.toPrecision(o[7]))):parseFloat(n);break;case"o":n=(parseInt(n,10)>>>0).toString(8);break;case"s":n=String(n),n=o[7]?n.substring(0,o[7]):n;break;case"t":n=String(!!n),n=o[7]?n.substring(0,o[7]):n;break;case"T":n=Object.prototype.toString.call(n).slice(8,-1).toLowerCase(),n=o[7]?n.substring(0,o[7]):n;break;case"u":n=parseInt(n,10)>>>0;break;case"v":n=n.valueOf(),n=o[7]?n.substring(0,o[7]):n;break;case"x":n=(parseInt(n,10)>>>0).toString(16);break;case"X":n=(parseInt(n,10)>>>0).toString(16).toUpperCase()}s.json.test(o[8])?b+=n:(!s.number.test(o[8])||f&&!o[3]?l="":(l=f?"+":"-",n=n.toString().replace(s.sign,"")),c=o[4]?"0"===o[4]?"0":o[4].charAt(1):" ",u=o[6]-(l+n).length,p=o[6]&&u>0?c.repeat(u):"",b+=o[5]?l+n+p:"0"===c?l+p+n:p+l+n)}return b}function n(e){if(i[e])return i[e];for(var t,r=e,n=[],a=0;r;){if(null!==(t=s.text.exec(r)))n.push(t[0]);else if(null!==(t=s.modulo.exec(r)))n.push("%");else{if(null===(t=s.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(t[2]){a|=1;var o=[],p=t[2],c=[];if(null===(c=s.key.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(c[1]);""!==(p=p.substring(c[0].length));)if(null!==(c=s.key_access.exec(p)))o.push(c[1]);else{if(null===(c=s.index_access.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(c[1])}t[2]=o}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");n.push(t)}r=r.substring(t[0].length)}return i[e]=n}var s={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^\)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[\+\-]/},i=Object.create(null);"undefined"!=typeof exports&&(exports.sprintf=e,exports.vsprintf=t),"undefined"!=typeof window&&(window.sprintf=e,window.vsprintf=t,"function"==typeof define&&define.amd&&define(function(){return{sprintf:e,vsprintf:t}}))}();
//import { sprintf } from "../utils/sprintf.util";

(function($,angular){
    'use_strict';

    var injectParams = ['Template','$sce','buy_url'];

    var Option = function(Template,$sce,buy_url){

        function Option(data){
            var s = this;

            s.credits = !!data.credits ? data.credits : '';
            s.first_name = !!data.first_name ? data.first_name : '';
            s.last_name = !!data.last_name ? data.last_name : '';
            s.company = !!data.company ? data.company : '';
            s.phone = !!data.phone ? data.phone : '';
            s.email = !!data.email ? data.email : '';
            s.license_key = !!data.license_key ? data.license_key : '';
            s.valid = !!data.isValid ? data.isValid : '';
            s.from = !!data.from ? data.from : '';
            s.blacklist = !!data.blacklist ? data.blacklist : '';
            s.templates = [];

            if(typeof data.templates == 'object' || typeof data.templates == 'array'){

                angular.forEach(data.templates,function(_template,index){
                    s.templates.push(new Template(_template));
                });

            }

            s.isValid = function(){

                return (
                    s.first_name != '' && 
                    s.last_name != '' &&
                    s.from != '' &&
                    s.phone != '' &&
                    s.email != '' &&
                    s.license_key != '' &&
                    s.valid
                ) ? true : false;

            }

            s.getBuyLink = function(){

                var url = sprintf(
                    '%s%s/?first_name=%s&last_name=%s&email=%s&phone=%s&company=%s',
                    buy_url,
                    s.license_key,
                    s.first_name,
                    s.last_name,
                    s.email,
                    s.phone,
                    s.company
                );

                return $sce.trustAsResourceUrl(url);
            };

            s.getSaveData = function(){

                var templates = [];

                angular.forEach(s.templates,function(_template,index){
                    templates.push(_template.getSaveData());
                });

                s.blacklist = s.blacklist.replace(/\s/g,'');

                if(s.blacklist != '' && s.blacklist.charAt(s.blacklist.length-1) !== ','){
                    s.blacklist = s.blacklist + ',';
                }

                return $.param({
                    credits      : s.credits,
                    first_name   : s.first_name,
                    last_name    : s.last_name,
                    company      : s.company,
                    from         : s.from,
                    phone        : s.phone,
                    email        : s.email,
                    license_key  : s.license_key,
                    templates    : templates,
                    blacklist    : s.blacklist,
                    action       : 'woo_sms_gf_update_options'
                });
            }

            return s;
        }

        return Option;
    }

    angular.module('woo-sms').factory('Option',Option);


})(jQuery,angular);
(function(angular){
    'use_strict';

    var injectParams = ["order_keys", "sms_max_chars"];

    var Template = function(order_keys,sms_max_chars){

        function Template(_template){

            var s = this;

            s.order_status = _template.order_status;
            s.order_status_title = _template.order_status_title;
            s.active = parseInt(_template.active) == 1 ? true : false;
            s.template = _template.template;
            s.language = _template.language;
            s.isfocus = false;

            s.activate = function(fTemplate){
                s.active = (parseInt(s.active) == 1 || s.active) ? false : true;

                if(s.active == false){
                    s.isfocus = false;
                }else{
                    s.isfocus = true;
                    fTemplate = s;
                }
            }

            s.compileTemplate = function(){

                var template = s.template;

                if(s.order_status !== 'send_to_all'){
                    angular.forEach(order_keys,function(k,i){
                        var reg = new RegExp( "{" +i + "}", "g" );
                        template = template.replace(reg, k);
                    });
                }

                return template == '' ? _woo_sms_gf.i18n.writeSomething : template;
            }

            

            s.smsCreditsNeeded = function(numbers){
                var t = s.compileTemplate().length;
                var smsLength = t == 0 ? 1 : t;
                return numbers * Math.ceil(smsLength / sms_max_chars);
            }

            s.getSaveData = function(){
                return {
                    order_status : s.order_status,
                    order_status_title : s.order_status_title,
                    active : s.active,
                    template : s.template,
                    language: s.language
                };
            }

            s.messageLength = function(msg){
                return s.compileTemplate().length;
            }

            return s;
        }

        return Template;
    }

    Template.$inject = injectParams;

    angular.module('woo-sms').factory('Template',Template);


})(angular);
(function (angular) {
    'use_strict';

    var injectParams = [];

    var Language = function () {

        function Language(_language) {

            console.log(_language);
            var s = this;

            s.id = _language.id;
            s.code = _language.code;
            s.current = _language.current == 1 ? true : false;
            s.default = _language.default == 1 ? true : false;
            s.display_name = _language.display_name;

            s.get_code = function(){
                return s.default ? 'default' : s.code;
            };

            return s;
        }

        return Language;
    };

    Language.$inject = injectParams;

    angular.module('woo-sms').factory('Language', Language);

})(angular); 
(function($,angular){
    'use_strict';

    var injectParams = ['$http', 'Option', 'LanguageService'];

    var OptionService = function ($http, Option, LanguageService){

        var s = this;
        
        s.object = _woo_sms_gf;
        s.LanguageService = LanguageService;

        s.get = function(){
            return new Option(s.object.options);
        };

        s.save = function(option){
            
            return $http({
                url : s.object.ajax_url,
                method : 'post',
                data : option.getSaveData(),
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8'
               }
            });

        };

        /**
         * Format date
         * 
         * @param {Date} dateObj
         */
        s.formatDate = function(dateObj){

            var dd = dateObj.getDate();
            var mm = dateObj.getMonth() + 1; //January is 0!

            var yyyy = dateObj.getFullYear();
            if (dd < 10) {
                dd = '0' + dd;
            }
            if (mm < 10) {
                mm = '0' + mm;
            }

            return yyyy + '-' + mm + '-' + dd;
            
        };

        s.getNewNumbers = function(date1,date2){

            var language = null;

            if (s.LanguageService.is_active()){
                language = s.LanguageService.get_current_code();
            }

            var new_date1 = s.formatDate(new Date(date1));
            var new_date2 = s.formatDate(new Date(date2));

            var data = $.param({
                from_date: new_date1,
                to_date: new_date2,
                language: language,
                action : 'woo_sms_gf_get_phone_numbers'
            });

            return $http({
                url : s.object.ajax_url,
                method : 'post',
                data : data,
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8'
                }
            });


        }

        return s;

    };

    OptionService.$inject = injectParams;

    angular.module('woo-sms').factory('OptionService',OptionService);

})(jQuery,angular);
(function ($, angular) {
    'use_strict';

    var injectParams = ['is_wpml_active', 'Language'];

    var LanguageService = function (is_wpml_active, Language) {

        var s = this;

        s.object = _woo_sms_gf;

        s.current_code = 'default';

        s.current_language = null;

        s.languages = [];

        s.is_active = function(){
            return is_wpml_active;
        };

        s.get = function(){

            if (!s.is_active()) return [];

            if(s.languages.length > 0) return s.languages;

            if(s.object.wpml_languages.length > 0){
                angular.forEach(s.object.wpml_languages, function(language){

                    var l = new Language(language);

                    if(l.current){
                        s.current_code = l.get_code();
                        s.current_language = l;
                    }

                    s.languages.push(l);

                });
            }

            return s.languages;

        };

        s.get_current_code = function(){
            return s.get_current().code;
        };

        s.get_current = function(){
            return s.current_language;
        };

        s.set_current = function(l){

            angular.forEach(s.languages, function(language){
                language.current = false;
            });

            s.current_code = l.get_code();
            s.current_language = l;
            l.current = true;

        };

        return s;

    };

    LanguageService.$inject = injectParams;

    angular.module('woo-sms').factory('LanguageService', LanguageService);



    angular.module('woo-sms').filter('languageFilter', ['LanguageService', function (LanguageService){
        
        function lFilter(_items){

            var items = [];

            angular.forEach(_items, function(item){
                if (item.language == LanguageService.current_code){
                    items.push(item);
                }
            });
            
            return items;
        }

        return lFilter;

    }]);


})(jQuery, angular); 
(function($,angular){
    'use_strict';

    var injectParams = ['$http', 'Message', '$timeout','LanguageService'];

    var SMSService = function ($http, Message, $timeout, LanguageService){

        var s = this;
        
        s.object = _woo_sms_gf;

        s.send_bulk_sms = function(to,from,message){

            var postData = $.param({
                action : 'woo_sms_gf_send_bulk_sms',
                to : to,
                from : from,
                message : message,
                language_code: LanguageService.current_code
            });
            
            return $http({
                url : s.object.ajax_url,
                method : 'post',
                data : postData,
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8'
               }
            }).then(function(success){
                return success.data;
            },function(error){
                //Do something
            });


        };

        s.send_sms = function(to, from, message){

            var postData = $.param({
                action : 'woo_sms_gf_send_sms',
                to : to,
                from : from,
                message : message
            });

            return $http({
                url : s.object.ajax_url,
                method : 'post',
                data : postData,
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8'
               }
            }).then(function(success){
                
                new Message({
                    msg : sprintf(s.object.i18n.sentTo, to),
                    type : 'success'
                });

                return success.data;

            },function(error){
                
                new Message({
                    msg : sprintf(s.object.i18n.couldNotSend, to),
                    type : 'error'
                });

            });


        };

        return s;

    };

    SMSService.$inject = injectParams;

    angular.module('woo-sms').factory('SMSService',SMSService);

})(jQuery,angular);
(function($,angular){
    'use_strict';

    var injectParams = ['$filter', '$scope','LanguageService','OptionService','validVariables','$timeout','sms_max_chars','$window','phoneNumbers', 'Template','SMSService', 'Message', 'i18n'];

    var MainController = function ($filter, $scope, LanguageService,OptionService,validVariables,$timeout,sms_max_chars,$window,phoneNumbers,Template,SMSService, Message, i18n){


        var ctrl = this;

        ctrl.option = OptionService.get();

        ctrl.languageService = LanguageService;

        ctrl.languages = LanguageService.get();

        console.log(ctrl.languageService.get_current());

        ctrl.updateStatus = false;
        ctrl.testStatus = false;
        ctrl.variables = validVariables;
        ctrl.focusedTemplate = '';
        ctrl.lastElement = null;
        ctrl.sms_max_chars = sms_max_chars;
        ctrl.buy_more = false;
        ctrl.showbuy = false;

        //Lock down system & bulk send!
        ctrl.lockDown = false;
        ctrl.numbersPerRequest = 100;
        ctrl.quepos = 0;
        ctrl.procentage = 0;
        ctrl.esitmatedTime = 0;
        ctrl.esitmatedMinutes = 0;
        ctrl.esitmatedSeconds = 0;
        ctrl.lastAjaxTime = 0;
        ctrl.usedCredits = 0;
        ctrl.loopCompleted = false;
        
        
        ctrl.sendSMSToAllTemplate = new Template({
            order_status : 'send_to_all',
            order_status_title : i18n.sendToAll,
            active : true,
            template : "",
            isfocus : false,
        });

        // Real numbers!
        ctrl.phoneNumbers = phoneNumbers.numbers;
        ctrl.countPhoneNumbers = phoneNumbers.count;
        ctrl.fromDate = new Date(phoneNumbers.date_from);
        ctrl.toDate = new Date(phoneNumbers.date_to); 
        ctrl.fetchingNumbers = false;
        ctrl.phoneText = i18n.fetchingCustomers;

        ctrl.setLanguage = function(language){
            ctrl.languageService.set_current(language);
            ctrl.changeFilter();
        };
        
        ctrl.blockAll = function(){
            
            if(ctrl.fetchingNumbers){
                ctrl.phoneText = i18n.fetchingCustomers;
            }else if(ctrl.countPhoneNumbers == 0){
                ctrl.phoneText = sprintf(i18n.couldNotFindBetween, $filter('date')(ctrl.fromDate, 'yyyy-MM-dd'), $filter('date')(ctrl.toDate, 'yyyy-MM-dd'));
            }else if(ctrl.option.credits == 0){
                ctrl.phoneText = i18n.noCreditsLeft;
            }

            if(ctrl.fetchingNumbers || ctrl.countPhoneNumbers == 0 || ctrl.option.credits == 0){
                return false;
            }

            return true;

        }

        ctrl.$onInit = function(){
            console.log("initiated");
            $scope.$watch('vm.fromDate', ctrl.changeFilter, true);
            $scope.$watch('vm.toDate', ctrl.changeFilter, true);
        };

        

        ctrl.getAvaliable = function(){
            return Math.floor(ctrl.option.credits / ctrl.sendSMSToAllTemplate.smsCreditsNeeded(1));
        }

        ctrl.changeFilter = function(val){

            if(($scope.optionForm.$invalid)){ return false; }

            ctrl.phoneNumbers = [];
            ctrl.fetchingNumbers = true;

            ctrl.countPhoneNumbers = 0;
            ctrl.blockAll();

            OptionService.getNewNumbers(ctrl.fromDate,ctrl.toDate).then(function(response){

                if(
                    angular.isObject(response.data) && 
                    angular.isDefined(response.data.success) && 
                    response.data.success == true &&
                    angular.isDefined(response.data.data) && 
                    angular.isObject(response.data.data)
                ){
                    var data = response.data.data;
                    ctrl.countPhoneNumbers = data.count;
                    ctrl.phoneNumbers = data.numbers;
                    ctrl.setDefualtValues();
                }

                ctrl.fetchingNumbers = false;


            }).catch(function(err){
                
                ctrl.fetchingNumbers = false;
            });

        }

        

        // ctrl.changeFilter();

        ctrl.saveOption = function(){

            if(($scope.optionForm.$invalid || !$scope.optionForm.$dirty) && !ctrl.updateStatus){
                return false;
            }

            ctrl.updateStatus = true;

            OptionService.save(ctrl.option).then(function(response){
                
                
                if(typeof response.data == 'object' && typeof response.data.success != 'undefined' && response.data.success == true){

                    ctrl.option.valid = response.data.data.option.isValid;                    
                    
                    new Message({
                        "msg" : i18n.settingsSaved,
                        "type" : "success"
                    });
                    ctrl.changeFilter();
                    

                }else{
                    new Message({
                        "msg" : i18n.settingsNotSaved,
                        "type" : "error"
                    });
                }

                ctrl.updateStatus = false;
                
                
                


            },function(error){
                ctrl.updateStatus = false;
                new Message({
                    "msg" : i18n.settingsNotSaved,
                    "type" : "error"
                });
            });

        };

        ctrl.isValid = function(){
            return ctrl.option.isValid();
        }

        ctrl.setDefualtValues = function(){

            $scope.optionForm.$setPristine();
            ctrl.updateStatus = false;

        }

        ctrl.addToTemplate = function($event,key){
            $event.preventDefault();
            $event.stopImmediatePropagation();
            
            if(ctrl.lastElement !== null){
                ctrl.lastElement.focus();
                $timeout(function(){
                    ctrl.focusedTemplate.template = ctrl.focusedTemplate.template + key;
                },0);
            }   
            
        }

        ctrl.addVariable = function(variable){
            if(ctrl.focusedTemplate.template == ""){
                ctrl.focusedTemplate.template = variable;
            }else{
                ctrl.focusedTemplate.template += " "  + variable;
            }
            
        }

        ctrl.buyMore = function(){
            $window.open(ctrl.option.getBuyLink());
        }

        ctrl.sendTest = function(){

            if(ctrl.focusedTemplate.template.length === 0){
                return false;
            }

            if(ctrl.focusedTemplate instanceof Template){
                ctrl.testStatus = true;

                SMSService.send_sms(ctrl.option.phone,ctrl.option.from,ctrl.focusedTemplate.compileTemplate()).then(function(response){

                    if(typeof response == 'object' && typeof response.success != 'undefined' && response.success == true){
                        ctrl.option.credits = response.data.credits;                    
                        ctrl.modifycredits(ctrl.option.credits);
                    }

                    ctrl.testStatus = false;
                });

            }

        }

        /**
         * Admin bar credits!
         */
        ctrl.modifycredits = function(credits){

            var e = angular.element(document.getElementById("credits"));
            if(e.length > 0){
                e[0].innerHTML = credits;
            }

        }


        ctrl.sendToAll = function(){

            var template = ctrl.sendSMSToAllTemplate;
            ctrl.lockDown = false;

            if(ctrl.countPhoneNumbers === 0){
                new Message({
                    msg : i18n.noCustomersWithNumbers,
                    type : 'error'
                });

                return false;
            }

            if(template.template.length === 0){
                return false;
            }

            var numbers = ctrl.getAvaliable();

            if(numbers < ctrl.sendSMSToAllTemplate.smsCreditsNeeded(ctrl.countPhoneNumbers)){
                ctrl.countPhoneNumbers = numbers;
                ctrl.phoneNumbers = ctrl.phoneNumbers.splice(0,numbers);
            }
            

            if(template instanceof Template && 
                confirm(sprintf(i18n.messageSendConfirm, template.smsCreditsNeeded(ctrl.countPhoneNumbers, ctrl.countPhoneNumbers)))){

                ctrl.lockDown = true;
                ctrl.numbersPerRequest = 100;
                ctrl.quepos = 0;
                ctrl.procentage = 0;
                ctrl.esitmatedTime = Math.ceil(ctrl.countPhoneNumbers / ctrl.numbersPerRequest) * 4;
                ctrl.esitmatedMinutes = Math.floor(ctrl.esitmatedTime / 60);
                ctrl.esitmatedSeconds = ctrl.esitmatedTime - (ctrl.esitmatedMinutes * 60);
                ctrl.lastAjaxTime = 0;
                ctrl.usedCredits = 0;
                ctrl.loopCompleted = false;

                ctrl.send_loop();

            }

        }

        

        
        ctrl.send_loop = function(){            

            var template = ctrl.sendSMSToAllTemplate;

            var timerStart = new Date().getTime() / 1000;
            var timerEnd = 0;
            
            if(ctrl.quepos >= ctrl.countPhoneNumbers){
                ctrl.procentage = 100;
                ctrl.loopCompleted = true;
                ctrl.changeFilter();
                return true;
            }

            var to = [];
            var from = ctrl.option.from;
            var template = template.compileTemplate();

            for(var i = 0; i<ctrl.numbersPerRequest; i++){
                var index = ctrl.quepos + i;
                if(typeof ctrl.phoneNumbers[ctrl.quepos + i] !== 'undefined'){
                    to.push(ctrl.phoneNumbers[ctrl.quepos + i]);
                }else{
                    ctrl.numbersPerRequest = i;
                }
            }

            SMSService.send_bulk_sms(to,from,template).then(function(response){

                if(typeof response == 'object' && typeof response.success != 'undefined' && response.success == true){
                    ctrl.usedCredits += response.data.used_credits;
                    ctrl.option.credits = response.data.credits;
                    ctrl.modifycredits(ctrl.option.credits);                 
                }


                ctrl.quepos += ctrl.numbersPerRequest;
                ctrl.procentage = Math.round((ctrl.quepos / ctrl.countPhoneNumbers) * 100);

                timerEnd = Math.round((new Date().getTime() / 1000) - timerStart);
                ctrl.esitmatedTime = Math.ceil((ctrl.countPhoneNumbers-ctrl.quepos) / ctrl.numbersPerRequest) * timerEnd;
                ctrl.esitmatedMinutes = Math.floor(ctrl.esitmatedTime / 60);
                ctrl.esitmatedSeconds = ctrl.esitmatedTime - (ctrl.esitmatedMinutes * 60);
                
                ctrl.send_loop();

            });
            

        };

        ctrl.closeLoop = function(){

            ctrl.setDefualtValues();
            ctrl.numbersPerRequest = 100;
            ctrl.quepos = 0;
            ctrl.procentage = 0;
            ctrl.esitmatedTime = Math.ceil(ctrl.countPhoneNumbers / ctrl.numbersPerRequest) * 4;
            ctrl.esitmatedMinutes = Math.floor(ctrl.esitmatedTime / 60);
            ctrl.esitmatedSeconds = ctrl.esitmatedTime - (ctrl.esitmatedMinutes * 60);
            ctrl.lastAjaxTime = 0;
            ctrl.usedCredits = 0;
            ctrl.loopCompleted = false;
            ctrl.lockDown = false;
            ctrl.blur();
            

        };

        ctrl.focus = function(_template,$event){

            var element = $($event.srcElement);
            
            ctrl.lastElement = element;
            ctrl.focusedTemplate = _template;
            _template.isfocus = true;

            var cellphone = $("body").find('div.cellphone').eq(0);
            var sidebar = $("body").find(".woo-sms div.sidebar").eq(0);

            var topPos = element.offset().top;
            var sidebarpos = sidebar.offset().top;
            var new_position = (topPos-sidebarpos) - 50;
            
            $("body").find('div.cellphone').css({
                "top" : new_position
            });

            $("html, body").animate({scrollTop:new_position},500);

        }

        ctrl.blur = function(){

            if(!ctrl.lockDown){

                ctrl.focusedTemplate.isfocus = false;
                ctrl.focusedTemplate = '';

            }
        }

        ctrl.reload = function(){
            $window.location.reload();
        }

        var addedEventListner = false;

        $scope.$watch('optionForm.$dirty',function(){
            
            if($scope.optionForm.$dirty){
                if(!addedEventListner){
                    window.addEventListener( 'beforeunload', areYouSurePrompt);
                    addedEventListner = true;
                }
            }else{
                addedEventListner = false;
                window.removeEventListener( 'beforeunload', areYouSurePrompt);
            }
        });


        


        function areYouSurePrompt(ev){
            return ev.returnValue = i18n.areYouSure;
        }

        return ctrl;

    };

    MainController.$inject = injectParams;

    angular.module('woo-sms').controller('MainController', MainController);

})(jQuery,angular);
(function($,angular){

    var injectParams = ['templateFolder'];

    var inputText = function(templateFolder){

        return {
            restrict : 'E',
            replace : true,
            transclude: true,
            scope : {
                ngModel: '=',
                label:'@',
                cssClass:'@',
                validate:'@',
                disabled:'@',
                required:'@',
                maxLength:'@',
                type:'@'
            },
            link: function(scope, element, attrs) {

                scope.cssClass = attrs.cssClass !== undefined ? attrs.cssClass : 'col-xs-12';
                scope.validateType = attrs.validate !== undefined ? attrs.validate : 'none';
                //scope.required = attrs.required == true ? true : false;

                if(angular.isUndefined(scope.type)){
                    scope.type='text';
                }

                
                scope.$watch(function(newValue,oldValue){
                    if(newValue.ngModel !== '' && newValue.ngModel !== undefined){
                        $(element).find('.fg-line').addClass('fg-toggled');
                    }else{
                        if(!$(element).find('input').is(':focus')){
                            $(element).find('.fg-line').removeClass('fg-toggled');
                        }
                    }
                });

            }, 
            templateUrl : templateFolder + "/directives/inputText.html"
        }
    };

    inputText.$inject = injectParams;

    angular.module('woo-sms').directive('inputText',inputText);

})(jQuery,angular); 
(function($,angular){

    function isValidDate(dateString) {
        
        var regEx = /^\d{4}-\d{2}-\d{2}$/;

        if(!dateString.match(regEx)) return false;  // Invalid format
        
        var d = new Date(dateString);
        if(!d.getTime() && d.getTime() !== 0) return false; // Invalid date
        return d.toISOString().slice(0,10) === dateString;
    }

    var validateIt = function(type, req, value, label, element){

        var result = {
            success : true,
            msg : sprintf(_woo_sms_gf.i18n.mustFill, label.toLowerCase())
        };

        //if not required and value is null return true
        if(!req && (value === '' || value === undefined)){

            if(type==="pwd"){
                angular.element($("input.pwdrepeat")).trigger("changed"); 
            }

            if(type === "pwdrepeat"){
                var pwd = $("input.pwd").val();
                if(pwd !== '' || pwd === undefined){
                    req = true;
                }

            }else{
                return result;
            }
        } 

        //if is required and value is null return false
        if(req && (value === '' || value === undefined)){
            result.success = false;
            return result;
        }

        

        switch(type){ 

            case "email" :
                if(!value.isEmail()){
                    result.msg = _woo_sms_gf.i18n.emailValidFail;
                    result.success = false;
                }
            break;
            case "number" :
                if(!value.isNumber()){
                    result.msg = _woo_sms_gf.i18n.numberValidFail;
                    result.success = false;
                }
            break;
            case "civic" :
                if(!value.isCivic()){
                    result.msg = _woo_sms_gf.i18n.socSecValidFail;
                    result.success = false;
                }
            break;

            case "date" :
                if(!isValidDate(value)){
                    result.msg = _woo_sms_gf.i18n.dateValidFail;
                    result.success = false;
                }
            break;

            case "pwd" :
                angular.element($("input.pwdrepeat")).trigger("changed"); 
                if(!value.isGoodPassword()){
                    result.msg = _woo_sms_gf.i18n.passLengthValidFail;
                    result.success = false;
                }
            break;
            case "pwdrepeat" :
                var v = $("input.pwd").val();
                //angular.element($("input.pwd")).trigger("changed"); 
                if(v !== value){
                    
                    result.msg = _woo_sms_gf.i18n.passValidFail;
                    result.success = false;
                }
            break;
            case "maxlength":
                var max = parseInt(element.attr('max-length'));
                if(value.length > max){
                    result.msg = sprintf(_woo_sms_gf.i18n.lengthValidFail, max);
                    result.success = false;
                }
            break;

        }

        return result;
    };


    var injectParams = [];

    var validateInput = function($sce){
        return{
            require: '?ngModel',
            link : function(scope, element, attrs, ngModel) {

                scope.ErrorMsg = "";
                scope.Valid = true;
                element.on('keyup blur changed',function(){
                    
                    var validationType = attrs.validateInput;

                    if(validationType !== "none" || scope.required){
                        var value = $(this).val();
                        var validated = validateIt(validationType,scope.required,value,scope.label,element);
                        if(!validated.success){ 
                            scope.ErrorMessage = validated.msg;
                            scope.Valid = false;
                            ngModel.$setValidity('required',false);
                            element.parent().addClass("invalid"); 
                        }else{
                            scope.Valid = true;
                            scope.ErrorMessage = "";
                            ngModel.$setValidity('required',true);
                            element.parent().removeClass("invalid");
                        }
                    }

                    scope.$apply();
                    
                });

                

            }
        };
    };

    validateInput.$inject = injectParams;
 
    angular.module('woo-sms').directive('validateInput',validateInput);
 
})(jQuery,angular); 
(function(angular){
    'use_strict';

    var injectParams = ['$timeout'];

    var focusOnShow = function ($timeout) {
        return {
            restrict: 'A',
            link: function ($scope, $element, $attr) {
                if ($attr.ngShow) {
                    $scope.$watch($attr.ngShow, function (newValue) {
                        if (newValue) {
                            $timeout(function () {
                                $element[0].focus();
                            }, 100);
                        } 
                    })
                }
                if ($attr.ngHide) {
                    $scope.$watch($attr.ngHide, function (newValue) {
                        if (!newValue) {
                            $timeout(function () {
                                $element[0].focus();
                            }, 100);
                        }
                    })
                }

            }
        };
    }

    focusOnShow.$inject = injectParams;

    angular.module("woo-sms").directive('focusOnShow',focusOnShow);

})(angular);
(function(angular){
    'use_strict';

    var injectParams = ['$timeout', '$parse'];

    var focusMe = function($timeout, $parse){
        return {
            //scope: true,   // optionally create a child scope
            link: function (scope, element, attrs) {
                
                var model = $parse(attrs.focusMe);
                
                //Watching your attribute
                scope.$watch(model, function (value) {
                    if (value === true) {
                        $timeout(function () {
                            element[0].focus();
                        });
                    }
                });

                // //On blur event
                // element.bind('blur', function () {
                //     scope.$apply(model.assign(scope, false));
                // });
            }
        };
    };

    focusMe.$inject = injectParams;

    angular.module('woo-sms').directive('focusMe',focusMe);

})(angular);
(function(angular){

    var injectParams = [];

    var blockDirective = function(){

        return {
            restirct : 'A',
            scope : {
                block : "=",
                blockText : "="
            },
            link : function($scope,$element){                

                var text = !!$scope.blockText ? $scope.blockText : _woo_sms_gf.i18n.mustSave;

                var $blockElement = angular.element('<div/>',{
                    class : 'block',
                    html : '<span>' + text + '</span>'
                });

                $element.append($blockElement);

                $scope.$watch('blockText',function(val){

                    var text = !!$scope.blockText ? $scope.blockText : _woo_sms_gf.i18n.mustSave;
                    $blockElement.html("<span>" + text + "</span>");
                    
                });

                $scope.$watch('block',function(val){
                    if(!val){
                        $blockElement.addClass("show");
                    }else{
                        $blockElement.removeClass("show");    
                    }
                });

            },
        }
 
    };

    blockDirective.$inject = injectParams;

    angular.module('woo-sms').directive('block',blockDirective);

})(angular);
(function(angular){
    
    var injectParams = ['templateFolder','$timeout','$interval'];

    var theIframe = function(templateFolder,$timeout,$interval){


        var interval;

        return {
            restrict : 'E',
            scope : {
                option : '=option',
                load : '=load',
                showbuy:'=showbuy'
            },
            replace : true,
            templateUrl : templateFolder + '/directives/theIframe.html',
            link : function($scope,$element,$attr){

                $scope.$watch('load',function(loaded){

                    if(loaded){
                        $element.find('iframe').bind('load', function (event) {

                            $scope.showbuy = true;

                            
                            var frame = angular.element(this);
                            frame.css({
                                opacity:0
                            });
        
                            interval = $interval(function(){
        
                                var height = frame.contents().find('body').height();                     
        
                                frame.css({
                                    height : height,
                                    opacity : 1
                                });
        
                            },1000);
                            
                        });
                    }else{
                        
                        $scope.showbuy = false;

                        if(angular.isDefined(interval)){
                            $interval.cancel(interval);
                            interval = undefined;
                        }
                        
                    }

                });

                $scope.$on('$destroy',function(){

                    if(angular.isDefined(interval)){
                        $interval.cancel(interval);
                        interval = undefined;
                    }

                });

                

            }
        };

    }

    theIframe.$inject = injectParams;

    angular.module('woo-sms').directive('theIframe',theIframe);

})(angular); 