<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (!class_exists("woo_sms_gf_assets")) {

    /**
     * This class is to handle the plugin assets.
     *
     * @author hampus alstermo<hampus@grafikfabriken.nu>
     * @version 1.0.0
     * @since 1.0.0
     */
    class woo_sms_gf_assets {

        private static $scripts = []; /* @var array woo_sms_gf_assets::$scripts */
        private static $styles = []; /* @var array woo_sms_gf_assets::$styles */

        /**
         * Register default plugin assets
         * @author hampus alstermo<hampus@grafikfabriken.nu>
         * @version 1.0
         * @since 1.0
         */
        public static function register_assets() {

            self::$scripts = apply_filters("woo_sms_gf_scripts", 
                array(
                    "woo_sms_gf_backend_woocommerce" => array("enqueue" => true, "url" => WOO_SMS_GF_SCRIPTS_URL . "woocommerce.js", "deps" => array('jquery'), "isFrontEnd" => false, 'localize' => array(
                        "obj" => '_woo_sms_gf_woo',
                        "values" => array(
                            "string" => __('Send text message to customer','woocommerce-sms-gf')
                        )
                    )),
                    "woo_sms_gf_backend_angular" => array("enqueue" => false, "url" => WOO_SMS_GF_SCRIPTS_URL . "angular.js", "deps" => array('jquery'), "isFrontEnd" => false),
                    "woo_sms_gf_backend_script" => array("enqueue" => false, "url" => WOO_SMS_GF_SCRIPTS_URL . "backend.js", "deps" => array('woo_sms_gf_backend_angular'), "isFrontEnd" => false,"localize" => array(
                        "obj" => "_woo_sms_gf",
                        "values" => array(
                            "numver" => '0606060',
                            "ajax_url" => admin_url('admin-ajax.php'),
                            "nonce" => wp_create_nonce('woo_sms_gf_nonce'),
                            "options" => wooSMSController()->get_options(),
                            'folder' => WOO_SMS_GF_APP_DIR_URL,
                            "valid_variables" => wooSMSTeamplateController()->valid_variables,
                            "order_keys" => wooSMSController()->get_order_keys(),
                            "sms_max_chars" => WOO_SMS_GF_MAX_CHARS,
                            "buy_url" => wooSMSRestController()->get_buy_url(),
                            "wpml_active" => wpmlController()->is_wpml_active(),
                            "wpml_languages" => wpmlController()->get_languages(),
                            'i18n' => array(
                                'sendToAll' => __('Send to all', 'woocommerce-sms-gf'),
                                'gettingCustomers' => __('Fetching customers...', 'woocommerce-sms-gf'),
                                'couldNotFindBetween' => __('Could not find any customers between<br>%s and %s', 'woocommerce-sms-gf'),
                                'noCreditsLeft' => __('You have no credits left', 'woocommerce-sms-gf'),
                                'settingsSaved' => __('Your settings have been saved', 'woocommerce-sms-gf'),
                                'settingsNotSaved' => __('Your settings could not be saved', 'woocommerce-sms-gf'),
                                'noCustomersWithNumbers' => __('Your settings have been saved', 'woocommerce-sms-gf'),
                                'messageSendConfirm' => __('This will cost %s credits and be sent to %s customers. Do you really want to send it?', 'woocommerce-sms-gf'),
                                'areYouSure' => __('Are you sure you want to leave?', 'woocommerce-sms-gf'),
                                'mustSave' => __('You have to save your settings', 'woocommerce-sms-gf'),
                                'mustFill' => __('You have to fill <strong>%s</strong>', 'woocommerce-sms-gf'),
                                'emailValidFail' => __('You have to enter a valid e-mail address', 'woocommerce-sms-gf'),
                                'numberValidFail' => __('This field may only contain numbers', 'woocommerce-sms-gf'),
                                'socSecValidFail' => __('This field must be formatted as \'YYYYMMDDXXXX\'', 'woocommerce-sms-gf'),
                                'dateValidFail' => __('Dates need to be formatted as \'YYYY-MM-DD\'', 'woocommerce-sms-gf'),
                                'passLengthValidFail' => __('Your password must be at least 8 characters long', 'woocommerce-sms-gf'),
                                'passValidFail' => __('The passwords do not match', 'woocommerce-sms-gf'),
                                'lengthValidFail' => __('This field must at most contain %s characters', 'woocommerce-sms-gf'),
                                'writeSomething' => __('Write something in the text field...', 'woocommerce-sms-gf'),
                                'couldNotSend' => __('Could not send a text message to %s. Do you have enough credits?', 'woocommerce-sms-gf'),
                                'sentTo' => __('Text message sent to %s', 'woocommerce-sms-gf'),
                            ),
                        )
                    )),
                )
            );


            self::$styles = apply_filters("woo_sms_gf_styles", array(
                "woo_sms_gf_backend_style" => array("url" => WOO_SMS_GF_STYLES_URL . "backend.css", "deps" => array(), "isFrontEnd" => false)
            ));

            foreach (self::$scripts as $key => $script) {
                wp_register_script($key, $script["url"], $script["deps"],false,true);
            }

            foreach (self::$styles as $key => $style) {
                wp_register_style($key, $style["url"], $style["deps"]);
            }

            if (is_admin()) {
                self::enqueue_backend_assets();
            } else {
                self::enqueue_frontend_assets();
            }
        }

        /**
         * Enqueueing frontend assets.
         * @version 1.0
         * @since 1.0
         * @author hampus alstermo<hampus@grafikfabriken.nu>
         */
        public static function enqueue_frontend_assets() {

            foreach (self::$scripts as $key => $script) {
                if ($script["isFrontEnd"]) {
                    //wp_enqueue_script($key);

                    if (isset($script["localize"]) && is_array($script["localize"]) && wooSMSarray_has_items($script["localize"])) {
                        wp_localize_script($key, (string) $script["localize"]["obj"], $script["localize"]["values"]);
                    }
                }
            }

            foreach (self::$styles as $key => $style) {
                if ($style["isFrontEnd"]) {
                    wp_enqueue_style($key);
                }
            }
        }

        /**
         * Enqueueing backend assets
         * @version 1.0
         * @since 1.0
         * @author hampus alstermo<hampus@grafikfabriken.nu>
         */
        public static function enqueue_backend_assets() {

            foreach (self::$scripts as $key => $script) {
                if (!$script["isFrontEnd"]) {
                    
                    if ($script["enqueue"]) {
                        wp_enqueue_script($key);
                    }

                    if (isset($script["localize"]) && is_array($script["localize"])) {
                        wp_localize_script($key, $script["localize"]["obj"], $script["localize"]["values"]);
                    }
                }
            }

            foreach (self::$styles as $key => $style) {
                if (!$style["isFrontEnd"]) {
                    wp_enqueue_style($key);
                }
            }
        }

    }

}