<?php
if(!defined('ABSPATH')){
    exit; // Exit if accsessd directly
}

if (!class_exists('Woo_SMS_Settings')) {


    /**
     * Woo SMS Settings
     *
     * @author Hampus Alstermo <hampus@grafikfabriken.nu>
     * @version 1.0
     */
    class Woo_SMS_Settings extends WOO_SMS_Singleton
    {
        /**
         * Option name in database
         *
         * @var string
         */
        public $option_name = 'woo_sms_gf';

        /**
         * Woo SMS Options
         *
         * @var Woo_SMS_Options
         */
        private $options;

        /**
         * Screen Name
         *
         * @var string
         */
        public $screen_name = 'sms-fabriken';

        /**
         * Dashicon
         *
         * @var string
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public $icon = 'dashicons-format-status';

        /**
         * API Errors
         *
         * @var array
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public $errors = array();

        /**
         * API Info
         *
         * @var array
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public $info = array();
        
        /**
         * Construct function
         *
         * @return void
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function _construct(){
            //Add some hooks after init
            add_action('plugins_loaded',array($this,'init'),1);
            //Enqueue some admin scripts
            add_action('admin_enqueue_scripts',array($this,'admin_enqueue_scripts'),9999);
        }

        /**
         * Keys avalible for SMS
         *
         * @return array
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function get_order_keys(){

            return array(
                "site_name" => get_bloginfo('name'),
                "site_url"  => get_home_url('/'),
                "order_id" => 1789354,
                "order_first_name" => "Maximiliam",
                "order_last_name" => "Willhelmsson"
            );

        }

        /**
         * Add some hooks on init
         *
         * @return void
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function init(){

            // You can only access this options from admin
            $this->set_options();

            //Is current user administrator
            if(is_user_logged_in() && current_user_can('administrator')){

                //Add menu item on the left hand side
                add_action('admin_menu',array($this,'admin_menu'));
                //Update options
                add_action('wp_ajax_woo_sms_gf_update_options', array($this,'ajax_update_options'));
                //Add admin bar items
                add_action('admin_bar_menu', array($this,'add_admin_bar_item'), 999);

            }
        }

        /**
         * Add credits to admin bar
         *
         * @param WP_Admin_Bar $wp_admin_bar
         * @return void
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         * @date [date]
         * @since [since]
         */
        public function add_admin_bar_item($wp_admin_bar) {
            $args = array(
                'id' => 'woocommerce-sms-credits',
                'title' => '<span class="ab-icon dashicons '.$this->icon.'"></span> ' . __('SMS balance', 'woocommerce-sms-gf') . ': <span id="credits">' . $this->options->credits . '</span>',
                'href' => $this->get_options_page_link(),
            );
            $wp_admin_bar->add_node($args);
        }

        /**
         * Update options with ajax
         *
         * @return void
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function ajax_update_options(){

            $default_option = $this->get_options();

            $option = wooSMSDeserializeData($_POST, 'Woo_SMS_Options');
            
            // So AJAX NOT CAN OVVERIDE KEYS AND CREDITS!
            $option->license_key = $default_option->get_license_key();
            $option->credits = $default_option->credits;

            $option->save();
            
            wp_send_json_success(array("option" => $option));
        }

        /**
         * Enqueu admin scripts on options page
         *
         * @return void
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function admin_enqueue_scripts(){
            /** @var WP_Screen $current_screen */
            global $current_screen;

            if(is_a($current_screen,'WP_Screen') && strpos($current_screen->id, $this->screen_name) !== false){
                wp_localize_script("woo_sms_gf_backend_script", '_woo_sms_gf_numbers', array("n" => wooSMSWooCommerceController()->get_all_phone_numbers()));
                wp_enqueue_script('woo_sms_gf_backend_script');
            }
        }

        /**
         * Get the options page link
         *
         * @return string
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function get_options_page_link(){
            return admin_url('admin.php?page=' . $this->screen_name);
        }

        /**
         * Add an settings page
         *
         * @return void
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function admin_menu(){
            add_menu_page(__('SMSFabriken', 'woocommerce-sms-gf'),__('SMSFabriken', 'woocommerce-sms-gf'),'administrator',$this->screen_name,array($this,'render_settings'),$this->icon);
        }

        /**
         * Set default options
         *
         * @return void
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function set_options(){

            //Defualt woocommerce Templates
            $default_templates = wooSMSTeamplateController()->build_default_templates();

            
            //Get option
            $options = get_option(
                $this->option_name,
                array(
                    'first_name'    => '',
                    'last_name'     => '',
                    'company'       => '',
                    'from'          => '',
                    'phone'         => '',
                    'email'         => '',
                    'license_key'   => '',
                    'blacklist'     => '0700000000, +46700000001',
                    'credits'       => 0,
                    'templates'     => $default_templates
                )
            );

            //Map data array to class
            $this->options = wooSMSDeserializeData($options,'Woo_SMS_Options');

            //Map Default templates
            $default_templates = wooSMSDeserializeData($default_templates, 'array[Woo_SMS_Template]');
            if(wooSMSarray_has_items($default_templates)){
                // wooSMSdpr($this->options,2);
                $this->options->templates = wooSMSTeamplateController()->compare_templates($default_templates, $this->options->templates);
            }
            
            // wooSMSdpr($this->options,2);

            if(!$this->options->get_license_key()){
                wooSMSRestController()->generate_license();
            }else{
                wooSMSRestController()->check_license($this->options->get_license_key());
            }

        }

        

        /**
         * Get Options
         *
         * @return Woo_SMS_Options
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function get_options(){
            return $this->options;
        }

        /**
         * Render Settings Page
         *
         * @return void
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function render_settings(){
            $options = $this->get_options();
            include WOO_SMS_GF_TEMPLATES_DIR . '/settings/app.tpl.php';

        }

    }

    /**
     * wrapper function for WOO SMS SETTINGS
     *
     * @return Woo_SMS_Settings
     * @author Hampus Alstermo <hampus@grafikfabriken.nu>
     * @version 1.0
     */
    function wooSMSController(){
        return Woo_SMS_Settings::getInstance();
    }

    wooSMSController(); // Run controller

}