<?php
if(!defined('ABSPATH')){
    exit; // Exit if accsessd directly
}

if (!class_exists('Woo_SMS_Template_Controller')) {


    /**
     * Woo SMS Settings
     *
     * @author Hampus Alstermo <hampus@grafikfabriken.nu>
     * @version 1.0
     */
    class Woo_SMS_Template_Controller extends WOO_SMS_Singleton
    {

        /**
         * Valid template variables
         *
         * @var array
         */
        public $valid_variables = array(
            "{order_id}",
            "{order_first_name}",
            "{order_last_name}",
            "{site_name}",
            "{site_url}"
        );
        
        /**
         * Construct function
         *
         * @return void
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function _construct(){

        }

        /**
         * Get Template keys with value!
         *
         * @param WC_Order $order
         * @return void
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function get_template_keys_keys($order){
            return is_a($order,'WC_Order') ? array(
                "order_id" => $order->get_id(),
                "order_first_name" => $order->get_billing_first_name(),
                "order_last_name" => $order->get_billing_last_name(),
                "site_name" => get_bloginfo('name'),
                "site_url"  => get_home_url('/')
            ) : array(
                "order_id" => 1337,
                "order_first_name" => "Test",
                "order_last_name" => "Testson",
                "site_name" => get_bloginfo('name'),
                "site_url"  => get_home_url('/')
            );
        }

        /**
         * Compare saved templates and plugin templates
         *
         * @param array[Woo_SMS_Template] $default_templates
         * @param array[Woo_SMS_Template] $saved_templates
         * @return void
         */
        public function compare_templates($default_templates, $saved_templates){

            $templates = [];

            foreach ($default_templates as $default_template) {
                /** @var Woo_SMS_Template $default_template */ $default_template;

                $saved = false;

                foreach ($saved_templates as $saved_template) {
                    /** @var Woo_SMS_Template $saved_template */ $saved_template;

                    if($saved_template->order_status === $default_template->order_status && $saved_template->language === $default_template->language && 
                        ($saved_template->template != $default_template->template || $saved_template->active)){
                        $templates[] = $saved_template;
                        $saved = true;
                        break;
                    }
                }

                if(!$saved){
                    $templates[] = $default_template;
                }

            }

            return $templates;
        }


        /**
         * Compile a template string
         *
         * @param string $template_string
         * @param WC_Order $order
         * @return string
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function compile_template($template_string, $order){

            
            $template = isset($template_string) ? (string) $template_string : "";

            if( strlen($template) > 0 && is_a($order, "WC_Order") ){

                $template = $template_string;

                $keys = $this->get_template_keys_keys($order);

                foreach($keys as $key => $value){
                    $template = preg_replace('/\{' . $key . '\}/', $value, $template);
                }

            }

            return $template;

        }

        /**
         * Build default templates
         *
         * @return array[Woo_SMS_Template]
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function build_default_templates(){
            
            $templates = [];
            $order_statuses = wc_get_order_statuses();

            foreach($order_statuses as $key => $value){

                $template_data = array(
                    "order_status"          => $key,
                    "order_status_title"    => $value,
                    "active"                => "0",
                    "language"              => "default",
                    "template"              => $this->get_default_template_string($key)
                );

                $templates[] = $template_data;

                //Run copys for WPML
                if(wpmlController()->is_wpml_active()){
                    $languages = wpmlController()->get_languages();
                    if(wooSMSarray_has_items($languages)){
                        foreach ($languages as $language) {
                            /** @var wooSMS_Language_Model $language */ $language;

                            if(!$language->default){

                                $language_template_data = array(
                                    "order_status" => sprintf("%s", $key),
                                    "order_status_title" => sprintf("%s (%s)", $value, $language->display_name),
                                    "active" => "0",
                                    "language" => $language->code,
                                    "template" => $this->get_default_template_string($key, $language)
                                );

                                $templates[] = $language_template_data;
                            }
                            
                        }
                    }
                }
            }

            return $templates;

        }

        /**
         * This is the plugins default templates
         *
         * @param string $status
         * @param wooSMS_Language_Model $language
         * @return string
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function get_default_template_string($status, $language = null){

            switch ($status) {
                case 'wc-pending':
                    return __('Hi! We are awaiting payment for your order ({order_id}). Best wishes, {site_name}.','woocommerce-sms-gf');
                case 'wc-processing':
                    return __('Hi! Your order ({order_id}) is now being processed. Best wishes, {site_name}.', 'woocommerce-sms-gf');
                case 'wc-on-hold':
                    return __('Hi! We have received your order ({order_id}). Best wishes, {site_name}.','woocommerce-sms-gf');
                case 'wc-completed':
                    return __('Hi! Your order ({order_id}) has now been sent out for shipping. Best wishes, {site_name}.','woocommerce-sms-gf');
                case 'wc-cancelled':
                    return __('Hello, your order ({order_id}) has been cancelled. Best wishes, {site_name}.','woocommerce-sms-gf');
                case 'wc-refunded':
                    return __('Hi! Your order ({order_id}) has been refunded. Best wishes, {site_name}.','woocommerce-sms-gf');
                case 'wc-failed':
                    return __('Hello, your order ({order_id}) could not be placed. Please try again. Best wishes, {site_name}.','woocommerce-sms-gf');
            }

        }

    }

    /**
     * wrapper function for Woo_SMS_Template_Controller
     *
     * @return Woo_SMS_Template_Controller
     * @author Hampus Alstermo <hampus@grafikfabriken.nu>
     * @version 1.0
     */
    function wooSMSTeamplateController(){
        return Woo_SMS_Template_Controller::getInstance();
    }

    wooSMSTeamplateController(); // Run controller

}