<?php
if(!defined('ABSPATH')){
    exit; // Exit if accsessd directly
}

if (!class_exists('Woo_SMS_WooCommerce_Controller')) {


    /**
     * Woo SMS WooCommerce Controller
     *
     * @author Hampus Alstermo <hampus@grafikfabriken.nu>
     * @version 1.0
     */
    class Woo_SMS_WooCommerce_Controller extends WOO_SMS_Singleton
    {

        /**
         * Active WooCommerce Statuses
         *
         * @var array
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public $active_statuses = [];
        
        /**
         * Construct function
         *
         * @return void
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function _construct(){

            add_action( 'plugins_loaded', array($this,"init"), 2 ); //Add all the status hooks!
            add_filter( 'init', array($this,'send_sms_order_note' ),10,3);
            add_action('wp_ajax_woo_sms_gf_get_phone_numbers',array($this,'ajax_get_all_phone_numbers'));

        }


        /**
         * Run this on plugins loaded
         * Cause wee need to hook in to
         * WooCommerce Actions!
         *
         * @return void
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function init(){

            

            //Setup active hooks!
            $order_statuses = wc_get_order_statuses();

            //Get options
            $option = wooSMSController()->get_options();

            //Loop foreach order status
            foreach($order_statuses as $key => $value){

                $nice_status_name = 'wc-' === substr( $key, 0, 3 ) ? substr( $key, 3 ) : $key;
                
                if($option->is_status_active($nice_status_name, 'all_languages')){
                    $this->active_statuses[] = $nice_status_name;
                    add_action( sprintf('woocommerce_order_status_%s', $nice_status_name), array($this,'send_sms_on_status'));
                }

            }

        }

        public function ajax_get_all_phone_numbers(){

            $date_from = isset($_POST["from_date"]) ? date_i18n("Y-m-d 00:00", strtotime(sanitize_text_field($_POST["from_date"]))) : null;
            $date_to = isset($_POST["to_date"]) ? date_i18n("Y-m-d 23:59:59", strtotime(sanitize_text_field($_POST["to_date"]))) : null;
            $language = isset($_POST["language"]) ? sanitize_text_field($_POST["language"]) : null;

            if($date_from === null && $date_to === null){
                wp_send_json_error("bad_options",503);
            }

            $result = $this->get_all_phone_numbers($date_from,$date_to, $language);
            wp_send_json_success($result);
        }

        /**
         * Get all phone numbers
         *
         * @return array
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function get_all_phone_numbers($date_from = null, $date_to = null, $language = null){

            global $wpdb;

            $date_from = $date_from == null ? date_i18n('Y-m-01 00:00') : $date_from;
            $date_to = $date_to == null ? date_i18n('Y-m-d H:i:s') : $date_to;

            /**
             * Set active language!
             */
            if(wpmlController()->is_wpml_active() && $language === null){
                $language = wpmlController()->get_current_language()->code;
            }

            
            $blackList = sanitize_text_field(rtrim(wooSMSController()->get_options()->blacklist,','));
            
            if($blackList != ''){
                $blackList = " AND " . PHP_EOL . "(pm.meta_value != '{$blackList}' AND FIND_IN_SET(pm.meta_value, '{$blackList}') = 0)";
            }

            $sql = "SELECT DISTINCT pm.meta_value AS numbers FROM {$wpdb->prefix}posts AS p ";
            $sql .= PHP_EOL . "INNER JOIN {$wpdb->prefix}postmeta as pm ON pm.post_id = p.ID and pm.meta_key = '_billing_phone'";

            if($language !== null && is_string($language) && wpmlController()->is_wpml_active()){
                $sql .= PHP_EOL . "INNER JOIN {$wpdb->prefix}postmeta as pm2 ON pm2.post_id = p.ID and pm2.meta_key = 'wpml_language'";
                $sql .= PHP_EOL . "WHERE";
                $sql .= PHP_EOL . "pm2.meta_value = '{$language}' AND";
            }else{
                $sql .= PHP_EOL . "WHERE";
            }

            $sql .= PHP_EOL . "p.post_type = 'shop_order' AND";
            $sql .= PHP_EOL . "p.post_date >= '{$date_from}' AND";
            $sql .= PHP_EOL . "p.post_date <= '{$date_to}'{$blackList}";
            $sql .= PHP_EOL . "LIMIT 9999999999";

            if($results = $wpdb->get_results($sql, ARRAY_A)){
                
                return array(
                    "count" => count($results),
                    "numbers" => wp_list_pluck($results,"numbers"),
                    "date_from" => date_i18n('Y-m-d', strtotime($date_from)),
                    "date_to" => date_i18n('Y-m-d', strtotime($date_to))
                );
            }

            return array(
                "count" => 0,
                "numbers" => array(),
                "date_from" => date_i18n('Y-m-d', strtotime($date_from)),
                "date_to" => date_i18n('Y-m-d', strtotime($date_to))
            );

        }

        /**
         * Send sms on order note $_POST request!!
         *
         * @return boolean
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function send_sms_order_note(){

            $action = isset($_POST["action"]) && $_POST["action"] === 'woocommerce_add_order_note' ? true : false;
            $note_type = isset($_POST["note_type"]) && $_POST["note_type"] === 'sms' ? true : false;
            $note = isset($_POST["note"]) ? wp_kses_post( trim( stripslashes( $_POST['note'] ) ) ) : false;
            $order = isset($_POST["post_id"]) ? wc_get_order($_POST["post_id"]) : false;

            if(is_user_logged_in() && current_user_can('edit_shop_orders') && $action && $note_type && is_a($order,'WC_Order') && $order->get_id() && $note !== false){

                $template = $note;
                $compiled_template = wooSMSTeamplateController()->compile_template($template, $order);
                $_POST["note"] = $compiled_template;
                $phone = (string) $order->get_billing_phone();
                $option = wooSMSController()->get_options();

                if(strlen($phone) > 7){

                    $sms_sent = wooSMSRestController()->send_sms($option->from, $phone, $compiled_template, $option->get_license_key());

                    if (is_a($sms_sent, 'stdClass') && isset($sms_sent->used_credits) && $sms_sent->used_credits > 0) {
                        $_POST["note"] = $compiled_template . sprintf(
                            __(" - Was sent by text message to %s. The message cost %s %s to send.", 'woocommerce-sms-gf'),
                            $phone,
                            $sms_sent->used_credits,
                            ($sms_sent->used_credits > 1) ? __('credits', 'woocommerce-sms-gf') : __('credit','woocommerce-sms-gf')
                        );
                        return true;
                    }

                }

                $_POST["note"] = $compiled_template . sprintf(__(" - Could not be sent by text message to %s.",'woocommerce-sms-gf'), $phone);
            
            }

            return false;
            
            
        }

        /**
         * Send SMS on Order status
         *
         * @param int $order_id
         * @return boolean
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function send_sms_on_status($order_id){

            $order = wc_get_order($order_id);
            
            if(is_a($order,'WC_Order') && $order->get_id() > 0){

                $status = $order->get_status();
                $phone = (string) $order->get_billing_phone();
                $order_language_code = 'default';

                if(wpmlController()->is_wpml_active()){
                    $order_language_code = wpmlController()->get_order_language($order_id);
                    $order_language_code = wpmlController()->check_if_code_is_default($order_language_code) ? 'default' : $order_language_code;
                }
                    
                if(wooSMSarray_has_items($this->active_statuses) && in_array($status,$this->active_statuses) && strlen($phone) > 7){
                    
                    $option = wooSMSController()->get_options();
                    $template = $option->get_template_by_status($status, $order_language_code, true);

                    if(is_a($template, 'Woo_SMS_Template')){
                        
                        $compiled_template = wooSMSTeamplateController()->compile_template($template->template,$order);
                        $sms_sent = wooSMSRestController()->send_sms($option->from, $phone, $compiled_template, $option->get_license_key());

                        if(is_a($sms_sent,'stdClass') && isset($sms_sent->used_credits) && $sms_sent->used_credits > 0){
                            
                            $order->add_order_note( 
                                sprintf(
                                    __('Sent text message to customer on order status: %s. The message cost %s %s to send.', 'woocommerce-sms-gf'),
                                    wc_get_order_status_name($order->get_status()),
                                    $sms_sent->used_credits,
                                    ($sms_sent->used_credits > 1) ? __('credits', 'woocommerce-sms-gf') : __('credit','woocommerce-sms-gf')
                                )
                            );

                            return true;

                        }else{
                            $order->add_order_note(sprintf(__('A text message could not be sent to: %s', 'woocommerce-sms-gf'), $phone));
                        }

                    }
                    
                }
                
            }

            return false;

        }

        /**
         * Build default templates
         *
         * @return array[Woo_SMS_Template]
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function build_default_templates(){
            
            $templates = [];
            $order_statuses = wc_get_order_statuses();

            foreach($order_statuses as $key => $value){

                $template_data = array(
                    "order_status"          => $key,
                    "order_status_title"    => $value,
                    "active"                => "0",
                    "template"              => $this->get_default_template_string($key)
                );

                $templates[] = $template_data;

                //Run copys for WPML
                if (wpmlController()->is_wpml_active()) {

                }

            }

            return $templates;

        }

        /**
         * This is the plugins default templates
         *
         * @param string $status
         * @return string
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function get_default_template_string($status){

            switch ($status) {
                case 'wc-pending':
                    return __('Hi! We are awaiting payment for your order ({order_id}). Best wishes, {site_name}.','woocommerce-sms-gf');
                case 'wc-processing':
                    return __('Hi! Your order ({order_id}) is now being processed. Best wishes, {site_name}.', 'woocommerce-sms-gf');
                case 'wc-on-hold':
                    return __('Hi! We have received your order ({order_id}). Best wishes, {site_name}.','woocommerce-sms-gf');
                case 'wc-completed':
                    return __('Hi! Your order ({order_id}) has now been sent out for shipping. Best wishes, {site_name}.','woocommerce-sms-gf');
                case 'wc-cancelled':
                    return __('Hello, your order ({order_id}) has been cancelled. Best wishes, {site_name}.','woocommerce-sms-gf');
                case 'wc-refunded':
                    return __('Hi! Your order ({order_id}) has been refunded. Best wishes, {site_name}.','woocommerce-sms-gf');
                case 'wc-failed':
                    return __('Hello, your order ({order_id}) could not be placed. Please try again. Best wishes, {site_name}.','woocommerce-sms-gf');
            }

        }

    }

    /**
     * wrapper function for Woo_SMS_WooCommerce_Controller
     *
     * @return Woo_SMS_WooCommerce_Controller
     * @author Hampus Alstermo <hampus@grafikfabriken.nu>
     * @version 1.0
     */
    function wooSMSWooCommerceController(){
        return Woo_SMS_WooCommerce_Controller::getInstance();
    }

    wooSMSWooCommerceController(); // Run controller
}