<?php
if(!defined('ABSPATH')){
    exit; //Silience is golden
}


if(!class_exists('WOO_SMS_WPML_Controller')){

    class WOO_SMS_WPML_Controller extends WOO_SMS_Singleton
    {

        /**
         * Is wpml loaded?
         *
         * @var boolean
         */
        protected $wpml_loaded;

        /**
         * Defualt wpml language
         *
         * @var wooSMS_Language_Model
         */
        protected $default_language;

        /**
         * Current wpml language
         *
         * @var wooSMS_Language_Model
         */
        protected $current_language;

        /**
         * All languages
         *
         * @var array[wooSMS_Language_Model]
         */
        protected $languages;


        /**
         * Construct WOO_SMS_WPML_Controller
         *
         * @return void
         */
        public function _construct(){

            //Set default value!
            $this->wpml_loaded = false;

            //Is WPML Active    
            if($this->is_wpml_active()){

                global $sitepress;

                //Set languages from WPML
                $this->set_languages();

                //Store languages temporary
                $languages = $this->get_languages();

                //Store default language code
                $default_language_code = $sitepress->get_default_language();
                $current_language_code = defined('ICL_LANGUAGE_CODE') ? ICL_LANGUAGE_CODE : '';

                if(wooSMSarray_has_items($languages)){
                    foreach ($languages as $language){
                        /** @var wooSMS_Language_Model $language */ $language;

                        //Try to set current language
                        if($language->code === $current_language_code){
                            $this->set_current_language($language);
                        }
                            
                        //Try to set default language
                        if($default_language_code === $language->code){
                            $this->set_default_language($language);
                        }

                    }
                }
            }
        }


        /**
         * Is wpml active
         *
         * @return boolean
         */
        public function is_wpml_active(){
            return $this->wpml_loaded ? true : ($this->wpml_loaded = function_exists('icl_get_languages'));
        }

        /**
         * Set default language
         *
         * @param wooSMS_Language_Model $language   
         * @return void
         */
        public function set_default_language($language){
            $language->default = true;
            $this->default_language = $language;
        }

        /**
         * Get default WPML Language
         *
         * @return wooSMS_Language_Model
         */
        public function get_default_language(){
            return $this->default_language;
        }

        /**
         * Language
         *
         * @param wooSMS_Language_Model $language
         * @return void
         */
        public function set_current_language($language){
            $language->current = true;
            $this->current_language = $language;
        }

        /**
         * Get order language
         *
         * @param int $order_id
         * @return string
         */
        public function get_order_language($order_id){

            $order_language = (string) get_post_meta($order_id, 'wpml_language', true);

            if(is_string($order_language) && strlen($order_language) > 0){
                return $order_language;
            }

            return '';

        }

        /**
         * Check if code is defualt
         *
         * @param string $language_code
         * @return true
         */
        public function check_if_code_is_default($language_code){

            $languages = $this->get_languages();

            if(wooSMSarray_has_items($languages)){
                foreach ($languages as $language) {
                    if($language->code == $language_code && $language->default === true){
                        return true;
                    }
                }
            }

            return false;

        }

        /**
         * Get current language
         *
         * @return wooSMS_Language_Model
         */
        public function get_current_language(){
            return $this->current_language;
        }

        /**
         * Get languages
         *
         * @return array[wooSMS_Language_Model]
         */
        public function get_languages(){
            return wooSMSarray_has_items($this->languages) ? $this->languages : array();
        }

        /**
         * Set all languages
         *
         * @return void
         */
        public function set_languages(){

            if(wooSMSarray_has_items($this->languages)){
                return $this->languages;
            }elseif($this->is_wpml_active()){
                $languages = icl_get_languages();
                $this->languages = array();

                if(wooSMSarray_has_items($languages)){
                    foreach ($languages as $language) {
                        if (isset($language["code"])) {
                            $this->languages[] = wooSMSDeserializeData($language, "wooSMS_Language_Model");
                        }
                    }
                }

            }else{
                $this->languages = [];
            }

            return $this->languages;

        }

    }

    /**
     * Get wpml controller
     *
     * @return WOO_SMS_WPML_Controller
     * 
     */
    function wpmlController(){
        return WOO_SMS_WPML_Controller::getInstance();
    }

}