<?php
if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (!function_exists("wooSMSdpr")) {
    /**
     * Debug variable through print_r().
     *
     * @param mixed $var
     * @param bool|int $die Discard buffer if $die equals 2
     * @param bool $return
     * @param string $style
     * @param string $key
     * @return string
     */
    function wooSMSdpr($var, $die = false, $return = false, $style = true, $key = null)
    {
        if ($key && !isset($_GET[$key])) {
            return;
        }
        $trace = debug_backtrace(false);
        $caller = array_shift($trace);
        $caller_info = sprintf('<div style="color:#36c;font-size:0.9em;">> %s:%s</div>', substr($caller['file'], strrpos($caller['file'], '/') + 1), $caller['line']);

        if ($style) {
            $dump = sprintf(
                    '<pre style="border:1px solid #ccc; background-color:#f0f0f0; padding:7px;">%s%s</pre>', $caller_info, print_r($var, true)
            );
        } else {
            $dump = sprintf(
                    '<p>%s</p>', print_r($var, true)
            );
        }

        if ($die) {
            if ($die === 2 && ob_get_length()) {
                ob_end_clean();
            }
            exit($dump);
        }
        if ($return) {
            return $dump;
        }
        ob_start(); ?>
        <style type="text/css">
            .preloader,
            #preloader{
                display: none!important;
            }
            html,
            body{
                opacity: 1!important;
            }
        </style>

        <?php
        $dump = ob_get_clean() . $dump;
        print $dump;
    }
}

if(!function_exists('wooSMSarray_has_items')){
    /**
     * Check if array has items
     *
     * @param array $arr
     * @return boolean
     * @author Hampus Alstermo <hampus@grafikfabriken.nu>
     * @version 1.0
     */
    function wooSMSarray_has_items($arr){
        return is_array($arr) && count($arr) > 0 ? true : false;
    }
}

if (!function_exists('wooSMSDeserializeData')) {
    function wooSMSDeserializeData($data, $class)
    {

        if(is_string($data) && wooSMSisJson($data)){
            $data = json_decode($data);
        }

        if ($data == null) {
            $deserialized = null;
        } elseif (substr($class, 0, 6) == 'array[') {
            $subClass = substr($class, 6, -1);
            $values = array();
            if (wooSMSarray_has_items($data)) {
                foreach ($data as $value) {
                    $values[] = wooSMSDeserializeData($value, $subClass);
                }
            }
            $deserialized = $values;
        
        } else if($class==='array'){
            $deserialized = $data;
        }  elseif ('\DateTime' == $class) {
            $deserialized = new \DateTime('@' . ($data / 1000), new \DateTimeZone('UTC'));
        } elseif ('\DT' == $class) {
            $deserialized = new \DateTime($data, new \DateTimeZone('UTC'));
        } elseif ('post_id' == $class) {

            $deserialized = null;

            if(class_exists('Custom_Cpt_Model')){
                $deserialized = get_custom_model($data);
            }
            
        } elseif ('time' == $class) { // @todo ADDED
        $deserialized = date_i18n("Y-m-d H:i:s", strtotime($data));
        } elseif (in_array($class, array('string', 'int', 'float', 'bool', 'time'))) {
            
            $data = str_replace('\"','"',$data); //Remove JSON FORMATTING
            $data = str_replace("\'","'",$data); //Remove JSON FORMATTING
            

            

            $data = sanitize_text_field($data);
            
            settype($data, $class);

            $data = str_replace("@me","",$data); //Remove JSON FORMATTING

            $deserialized = $data;
        } else {
            $instance = new $class();
            foreach ($instance->dataTypes as $property => $type) {
                if (isset($data->$property)) {
                    $instance->$property = wooSMSDeserializeData($data->$property, $type);
                }elseif (is_array($data) && isset($data[$property])){
                    $instance->$property = wooSMSDeserializeData($data[$property], $type);
                }
            }
            $deserialized = $instance;
        }

        return $deserialized;
    }
}

if(!function_exists('wooSMSisJson')){
    /**
     * Is string a json?
     *
     * @param string $string
     * @return boolean
     */
    function wooSMSisJson($string) {
        json_decode($string);
        return (json_last_error() == JSON_ERROR_NONE);
    }
}