<?php

class wooSMS_Language_Model{

    /**
     * Language id
     *
     * @var int
     */
    public $id;

    /**
     * Language code
     *
     * @var string
     */
    public $code;

    /**
     * English name
     *
     * @var string
     */
    public $english_name;

    /**
     * Native name
     *
     * @var string
     */
    public $native_name;

    /**
     * Is a major name?
     *
     * @var bool
     */
    public $major;

    /**
     * Is language active
     *
     * @var bool
     */
    public $active;

    /**
     * Default locale
     *
     * @var string
     */
    public $default_locale;

    /**
     * Encode url
     *
     * @var strin
     */
    public $encode_url;

    /**
     * Tag
     *
     * @var string
     */
    public $tag;

    /**
     * Display name
     *
     * @var string
     */     
    public $display_name;

    /**
     * Is language the current language?
     *
     * @var bool
     */
    public $current;

    /**
     * Is language the default language?
     *
     * @var bool
     */
    public $default;

    /**
     * DataTypes
     *
     * @var array
     */
    public $dataTypes = [
        "code" => "string",
        "id" => "string",
        "english_name" => "string",
        "native_name" => "string",
        "major" => "string",
        "active" => "string",
        "default_locale" => "string",
        "encode_url" => "string",
        "tag" => "string",
        "display_name" => "string",
    ];

    public function __construct()
    {
        
    }

}