<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if (!class_exists('Woo_SMS_Options')) {

    /**
     * Woo_SMS_Options
     *
     * @author Hampus Alstermo <hampus@grafikfabriken.nu>
     * @version 1.0
     */
    class Woo_SMS_Options implements JsonSerializable{

        /**
         * Total credits
         *
         * @var integer
         */
        private $credits;

        /**
         * First name
         *
         * @var string
         */
        private $first_name;

        /**
         * Last name
         *
         * @var string
         */
        private $last_name;

        /**
         * Company name
         *
         * @var string
         */
        private $company;

        /**
         * E-mail
         *
         * @var string
         */
        private $email;

        /**
         * Phone
         *
         * @var string
         */
        private $phone;

        /**
         * Templates
         *
         * @var array
         */
        private $templates;

        /**
         * A blacklist of phonenumbers
         *
         * @var string
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        private $blacklist;

        /**
         * License key
         *
         * @var string
         */
        private $license_key;

        /**
         * DataTypes for deserialatzion
         *
         * @var array
         */
        public $dataTypes = array(
            "credits"       => "string",
            "first_name"    => "string",
            "last_name"     => "string",
            "company"       => "string",
            "from"          => "string",
            "phone"         => "string",
            "email"         => "string",
            "templates"     => "array[Woo_SMS_Template]",
            "blacklist"     => "string",
            "license_key"   => "string"
        );

        /**
         * Construct function
         *
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         * @return void
         */
        public function __construct(){

        }

        /**
         * Set values
         *
         * @param string $key
         * @param string|array|int|boolean $value
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0         
         */
        public function __set($key, $value = ""){

            $keys = array_keys($this->dataTypes);
            
            if(in_array($key,$keys)){

                if($key === 'credits'){
                    $this->credits = (int) $value;
                    
                }else{
                    $this->$key = $value;
                }
                
            }
        }

        /**
         * Get values
         *
         * @param string $key
         * @return string|boolean|array
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function __get($key){
            $keys = array_keys($this->dataTypes);
            
            if(in_array($key,$keys) && isset($this->$key)){
                return $this->$key;
            }

            return false;
        }

        /**
         * Is OPtion Valid
         *
         * @return boolean
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function isValid(){

            return  $this->first_name != '' && 
                    $this->last_name != '' &&
                    $this->from != '' &&
                    $this->phone != '' &&
                    $this->email != '' &&
                    $this->license_key != ''? true : false;

        }

        /**
         * Save options
         *
         * @return boolean
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function save(){

            $option = array();

            if (isset($this->blacklist) && is_string($this->blacklist)) {
                $this->blacklist = rtrim($this->blacklist, ',');
            }

            foreach ($this->dataTypes as $k => $v) {
                $option[$k] = $this->$k;
            }

            
                
            return update_option(wooSMSController()->option_name, json_encode($option,  JSON_HEX_QUOT));
        }

        /**
         * Is WooCommerce Status Active?!
         *
         * @param stromg $status
         * @return boolean
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function is_status_active($status, $lang = "default"){

            $template = $this->get_template_by_status($status, $lang, true);

            return is_a($template,'Woo_SMS_Template') ? true : false;

        }

        /**
         * Get template by status
         *
         * @param string $status
         * @return Woo_SMS_Template
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function get_template_by_status($status, $lang="default", $use_active=false){

            $nice_status_name = 'wc-' === substr( $status, 0, 3 ) ? $status : 'wc-' . $status;

            foreach($this->templates as $template){
                if(
                    is_a($template,'Woo_SMS_Template') && 
                    $template->order_status == $nice_status_name && 
                    ($lang === 'all_languages' || $template->language == $lang)
                    ){

                        if($use_active){
                            if($template->is_active()){
                                return $template;            
                            }
                        }else{
                            return $template;
                        }

                    
                }
            }

            return false;

        }

        /**
         * Get license key
         *
         * @return string
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function get_license_key(){
            return $this->license_key;
        }

        /**
         * Return an array on json_decode
         *
         * @return array
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function jsonSerialize()
        {
            return array(
                "credits"       => $this->credits,
                "first_name"    => $this->first_name,
                "last_name"     => $this->last_name,
                "company"       => $this->company,
                "from"          => $this->from,
                "phone"         => $this->phone,
                "email"         => $this->email,
                "templates"     => $this->templates,
                "license_key"   => $this->get_license_key(),
                "blacklist"     => $this->blacklist,
                "isValid"       => $this->isValid()
            );
        }
    }
}