<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if (!class_exists('Woo_SMS_Template')) {

    /**
     * Woo_SMS_Template
     *
     * @author Hampus Alstermo <hampus@grafikfabriken.nu>
     * @version 1.0
     */
    class Woo_SMS_Template implements JsonSerializable, Serializable{

        /**
         * Order status
         *
         * @var string
         */
        public $order_status;

        /**
         * Order status titel
         *
         * @var string
         */
        public $order_status_title;

        /**
         * Active
         *
         * @var boolean
         */
        public $active;

        /**
         * Template
         *
         * @var string
         */
        public $template;

        /**
         * Language id
         *
         * @var string
         */
        public $language;


        public $dataTypes = array(
            "order_status"        => "string",
            "order_status_title"  => "string",
            "active"              => "string",
            "template"            => "string",
            "language"            => "string"
        );

        /**
         * Construct function
         *
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         * @return void
         */
        public function __construct(){
            
        }

        /**
         * Set values
         *
         * @param string $key
         * @param string|array|int|boolean $value
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0         
         */
        public function __set($key, $value){

            $keys = array_keys($this->dataTypes);
            
            if($value && in_array($key,$keys)){

                $this->$key = $value;

            }
        }

        /**
         * Get values
         *
         * @param string $key
         * @return string|boolean|array
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function __get($key){
            $keys = array_keys($this->dataTypes);
            
            if(in_array($key,$keys)){
                return $this->$key;
            }

            return false;
        }


        /**
         * Is template active
         *
         * @return boolean
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function is_active(){
            return $this->active == "1" ? true : false;
        }

        /**
         * Save Template
         *
         * @return boolean
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function save(){

            $option = array();

            foreach ($this->dataTypes as $k => $v) {
                $option[$k] = $this->$k;
            }
                
            return update_option(wooSMSController()->option_name,$option);
        }

        /**
         * Return an array on json_decode
         *
         * @return array
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function jsonSerialize()
        {
            return array(
                "order_status"       => $this->order_status,
                "order_status_title" => $this->order_status_title,
                "active"             => $this->active,
                "template"           => $this->template,
                "language"           => $this->language,
            );
        }

        /**
         * Returns an array on serialze()
         *
         * @return array
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function serialize()
        {
            return array(
                "order_status"       => $this->order_status,
                "order_status_title" => $this->order_status_title,
                "active"             => $this->active,
                "template"           => $this->template,
                "language"           => $this->language,
            );
        }

        /**
         * Unserialize option
         *
         * @param string $serialized
         * @return array
         */
        public function unserialize($serialized)
        {
            return unserialize($serialized);
        }

    }

}