<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$woo_sms_gf_includes = [
    'functions.php', // Plugin functions
    'classes/singleton.class.php', // Singleton class
    'classes/assets.class.php', // An Assets class
    'classes/curl.class.php', // An Curl Class
    'models/settings.model.php', // A Model for Settings
    'models/template.model.php', // A Model for Templates
    'models/language.model.php', // A Model for languages
    'controllers/wpml.controller.php', // A Controller for WPML
    'controllers/settings.controller.php', // A Controller for WooSMS Settings
    'controllers/template.controller.php', // A Controller for WooSMS Templates
    'controllers/rest.controller.php', // A Controller for WooSMS Rest
    'controllers/woocommerce.controller.php', // A Controller for WooSMS Woocommerce Controller
];

foreach ($woo_sms_gf_includes as $file) {
    $file = WOO_SMS_GF_LIB_DIR . "/" . $file;
    if (!file_exists($file)) {
        trigger_error(sprintf(__('Could not find %s for inclusion.'), $file), E_USER_ERROR);
    }
    require_once $file;
}

unset($file, $filepath);
