<div class="woo-sms container" ng-app="woo-sms" ng-cloak>

    <?php if(wooSMSarray_has_items($this->errors)) : ?>

        <ul class="errors">
            <?php foreach($this->errors as $error): ?>
                <li><?= $error; ?></li>
            <?php endforeach; ?>
        </ul>

    <?php endif; ?>

    <?php if(wooSMSarray_has_items($this->info)) : ?>

        <ul class="info">
            <?php foreach($this->info as $in): ?>
                <li><?= $in; ?></li>
            <?php endforeach; ?>
        </ul>

    <?php endif; ?>

    <form name="optionForm">
        <div class="options" ng-controller="MainController as vm">

            <div class="row language-picker" ng-show="vm.languageService.is_active()">
                <div class="col col-xs-12">
                    <div class="box">
                        <h1><?= __('Choose which language to edit', 'woocommerce-sms-gf') ?></h1>
                        <div class="box-content" block="vm.isValid()">
                            <div class="info">
                                <i><?= sprintf(__('You need to edit all templates for the languages you plan to use. Your current language is: %s', 'woocommerce-sms-gf'), "<strong>{{vm.languageService.current_language.display_name}}</strong>"); ?></i>
                            </div>
                            <ul>
                                <li ng-click="vm.setLanguage(language)" ng-class="{ 'active' : language.current }" ng-repeat="language in vm.languages">{{language.display_name}}</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- FIRST ROW -->
            <div class="row" ng-hide="vm.buy_more">
                <div class="main col col-xs-12 col-md-6">
                    <div class="box sms">
                        <h1><?=__('Text Message Templates', 'woocommerce-sms-gf')?></h1>
                        <div class="box-content" block="vm.isValid()">
                            <div class="info">
                                <?= __('Activate automatic text message notifications on order status change','woocommerce-sms-gf'); ?>
                            </div>
                            <ul class="templates">
                                <li class="template" ng-repeat="template in vm.option.templates | languageFilter" ng-class="{ theactive : template.isfocus && !vm.lockDown}">
                                    <div class="row-info" ng-click="template.activate(vm.focusedTemplate);">
                                        <h3>{{template.order_status_title}}</h3>
                                        <div class="toggle_switch">
                                            <label class="toggle">
                                                <input type="checkbox" ng-model="template.active">
                                                <span class="slider round"></span>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="content" ng-if="template.active">
                                        <textarea rows="3" focus-me="template.isfocus" ng-show="template.active" ng-focus="vm.focus(template,$event)" ng-model="template.template"></textarea>
                                        <div class="variables">
                                            <strong ng-show="template.isfocus"><?= __('Click to add a variable to the message: ','woocommerce-sms-gf'); ?></strong>
                                            <ul class="comma-seperated" ng-show="template.isfocus">
                                                <li ng-repeat="variable in vm.variables" ng-click="vm.addVariable(variable)">{{variable}}</li>
                                            </ul>
                                        </div>
                                        <div class="buttons" ng-show="template.isfocus">
                                            <div class="btn btn-primary send-test" ng-if="vm.option.credits > 0" ng-class="{'loading-state' : vm.testStatus }" ng-disabled="template.template == '' && !vm.testStatus" ng-click="vm.sendTest()">
                                                <span ng-hide="vm.testStatus"><?=__('SEND TEST MESSAGE','woocommerce-sms-gf')?></span>
                                                <span ng-show="vm.testStatus" class="dashicons dashicons-update"></span>
                                            </div>

                                            <div ng-click="vm.saveOption()" ng-class="{'loading-state' : vm.updateStatus }" class="btn btn-green" ng-disabled="(optionForm.$invalid || !optionForm.$dirty) && !vm.updateStatus">
                                                <span ng-hide="vm.updateStatus"><?=__('Save','woocommerce-sms-gf')?></span>
                                                <span ng-show="vm.updateStatus" class="dashicons dashicons-update"></span>
                                            </div>

                                            <div ng-click="vm.blur()" class="btn btn-danger">
                                                <span><?=__('Close','woocommerce-sms-gf')?></span>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="box cta" ng-show="vm.isValid()" ng-class="{errors : vm.option.credits <= 20}">
                        <div class="box-content" ng-click="vm.buyMore()" block="vm.isValid()">
                            <div class="line"></div>
                            <div class="line2"></div>
                            <h1><?=__('Buy more text messages!', 'woocommerce-sms-gf')?></h1>
                            <h4><?= sprintf(__('You only have %s left','woocommerce-sms-gf'), '{{vm.option.credits}}'); ?></h4>
                            <a ng-class="{'btn-green' : vm.option.credits > 10, 'btn-danger' : vm.option.credits < 10}" class="btn"><?=__('Buy more','woocommerce-sms-gf')?></a>
                        </div>
                    </div>
                </div>
                <div class="sidebar col col-xs-12 col-md-6">
                    <div class="cellphone" ng-show="vm.focusedTemplate.isfocus && !vm.lockDown" ng-class="{ 'right' : (vm.focusedTemplate.order_status == 'send_to_all') }">
                        <div class="top"></div>
                        <div class="main" ng-class="{ error : vm.focusedTemplate.messageLength() > vm.sms_max_chars}">
                            <div class="heading">{{vm.focusedTemplate.order_status_title}}</div>
                            <div class="message">{{vm.focusedTemplate.compileTemplate()}}</div>
                            <div class="message-length">{{vm.focusedTemplate.messageLength()}} / {{vm.sms_max_chars}}</div>
                            <div class="author">{{vm.option.from}}</div>
                            
                            <div class="error-msg"><?= __('This text message may be split into multiple messages.', 'woocommerce-sms-gf'); ?></div>
                        </div>
                        <div class="bottom"><div class="cell-button"></div></div>
                        <div class="shine"></div>
                    </div>
                    <div class="focusframe" ng-show="vm.focusedTemplate.isfocus" ng-click="vm.blur()"></div>
                    <div class="box settings">
                        <h1><?= __('Settings','woocommerce-sms-gf'); ?></h1>
                        <div class="box-content">
                            <div class="row">
                                <input-text css-class="col col-xs-12 col-sm-6" ng-model="vm.option.first_name" required="true" label="<?= __('First name', 'woocommerce-sms-gf'); ?>"></input-text>
                                <input-text css-class="col col-xs-12 col-sm-6" ng-model="vm.option.last_name" required="true" label="<?= __('Last name', 'woocommerce-sms-gf'); ?>"></input-text>
                                <input-text css-class="col col-xs-12 col-sm-6" ng-model="vm.option.company" label="<?= __('Business', 'woocommerce-sms-gf'); ?>"></input-text>
                                <input-text css-class="col col-xs-12 col-sm-6" ng-model="vm.option.email" validate="email" required="true" label="<?= __('E-mail', 'woocommerce-sms-gf'); ?>"></input-text>
                                <input-text css-class="col col-xs-12 col-sm-12" ng-model="vm.option.phone" required="true" label="<?= __('Phone (For test message)', 'woocommerce-sms-gf'); ?>"></input-text>
                                <input-text css-class="col col-xs-12 col-sm-12" ng-model="vm.option.from" validate="maxlength" max-length="11" required="true" label="<?= __('Sender (max 11 chars)', 'woocommerce-sms-gf'); ?>"></input-text>   
                                <input-text css-class="col col-xs-12" ng-model="vm.option.license_key" disabled="true" required="true" label="<?= __('License key', 'woocommerce-sms-gf'); ?>"></input-text>

                                <div class="form-group col-xs-12 textarea">
                                    <label class="fg-label"><?= __("Don't send messages to these phone numbers (comma separated). Remember to use the same phone number as entered on the order!", 'woocommerce-sms-gf');?></label>
                                    <textarea type="text" name="blacklist" class="input-sm form-control fg-input" ng-model="vm.option.blacklist"></textarea>
                                </div>

                            </div>

                            <div ng-click="vm.saveOption()" ng-class="{'loading-state' : vm.updateStatus }" class="btn btn-green" ng-disabled="(optionForm.$invalid || !optionForm.$dirty) && !vm.updateStatus">
                                <span ng-hide="vm.updateStatus"><?=__('Save','woocommerce-sms-gf')?></span>
                                <span ng-show="vm.updateStatus" class="dashicons dashicons-update"></span>
                            </div>

                        </div>
                    </div>
                    <div class="box settings sendtoall">
                        <h1><?= __('Send to all of your customers','woocommerce-sms-gf'); ?></h1>
                        <div class="box-content" block="vm.isValid()">
                            <div class="info" ng-if="vm.languageService.is_active()">
                                <?= sprintf(__('This text message will only be sent to customers who ordered with language: %s', 'woocommerce-sms-gf'), '{{vm.languageService.get_current().display_name}}'); ?>
                            </div>
                            <div class="row">
                                <div class="filter-numbers">
                                    <div class="col col-xs-12">
                                        <h3><?= __('Send to all customers that placed an order between:', 'woocommerce-sms-gf')?></h3>
                                    </div>
                                    <input-text css-class="col col-xs-12" type="date" ng-model="vm.fromDate" validate="date" label="<?= __('From', 'woocommerce-sms-gf'); ?>"></input-text>
                                    <input-text css-class="col col-xs-12" type="date" ng-model="vm.toDate" validate="date"  label="<?= __('To', 'woocommerce-sms-gf'); ?>"></input-text>
                                </div>

                                <div class="col col-xs-12" ng-class="{ theactive : vm.sendSMSToAllTemplate.isfocus && !vm.lockDown}">

                                    <div class="row-info">
                                        <h3><?= sprintf(__('Send message to %s clients', 'woocommerce-sms-gf'), '{{vm.countPhoneNumbers}}'); ?></h3>
                                    </div>
                                    
                                    

                                    <div class="content" block="vm.blockAll()" block-text="vm.phoneText">
                                        
                                        <textarea rows="3" ng-focus="vm.focus(vm.sendSMSToAllTemplate,$event)" ng-model="vm.sendSMSToAllTemplate.template"></textarea>
                                        <ul class="info-list" ng-show="vm.sendSMSToAllTemplate.isfocus && !vm.lockDown">
                                            <li><?= __('Number of customers:', 'woocommerce-sms-gf')?> {{vm.countPhoneNumbers}}</li>
                                            <li><?= __('Cost in SMS-credits:', 'woocommerce-sms-gf')?> {{vm.sendSMSToAllTemplate.smsCreditsNeeded(vm.countPhoneNumbers)}}</li>
                                            <li ng-show="vm.sendSMSToAllTemplate.smsCreditsNeeded(vm.countPhoneNumbers) > vm.option.credits">
                                                <strong><?= sprintf(__('You will only be able to send text messages to %s of %s clients', 'woocommerce-sms-gf'), '{{vm.getAvaliable()}}', '{{vm.countPhoneNumbers}}'); ?></strong>
                                            </li>
                                        </ul>
                                        <div class="buttons" ng-show="vm.sendSMSToAllTemplate.isfocus && !vm.lockDown">

                                            <div class="btn btn-primary send-test" ng-class="{'loading-state' : vm.testStatus }" ng-disabled="vm.sendSMSToAllTemplate.template == '' && !vm.testStatus" ng-click="vm.sendTest()">
                                                <span ng-hide="vm.testStatus"><?=__('SEND TEST MESSAGE','woocommerce-sms-gf')?></span>
                                                <span ng-show="vm.testStatus" class="dashicons dashicons-update"></span>
                                            </div>

                                            <div ng-click="vm.sendToAll()" ng-class="{'loading-state' : vm.updateStatus }" class="btn btn-green" ng-disabled="vm.sendSMSToAllTemplate.template == ''">
                                                <span ng-hide="vm.updateStatus"><?=__('Send to all','woocommerce-sms-gf')?></span>
                                                <span ng-show="vm.updateStatus" class="dashicons dashicons-update"></span>
                                            </div>

                                            <div ng-click="vm.blur()" class="btn btn-danger">
                                                <span><?=__('Close','woocommerce-sms-gf')?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                    
                </div>
            </div> 
            <!-- END OF FIRST ROW -->
            <!-- SECOND ROW -->
            <div class="row mtop buymore" ng-if="vm.buy_more">
                <div class="col col-xs-12">
                        <div class="action" ng-show="vm.showbuy">
                            <h1><?= __("Buy more text nessages", "woocommerce-sms-gf") ?></h1>
                            <a class="btn btn-green" ng-click="vm.reload();"><?= __("Back", "woocommerce-sms-gf"); ?></a>
                        </div>
                        <the-iframe option="vm.option" load="vm.buy_more" showbuy="vm.showbuy"></the-iframe>
                </div>
            </div>
            <div class="preloader-window" ng-show="vm.lockDown">
                <div class="box">
                    <div class="loop" ng-show="!vm.loopCompleted">
                        <h3><?= __('Sending a text message to your chosen customers', 'woocommerce-sms-gf')?></h3>
                        <span class="notice"><?= __("(Do not close this window)",'woocommerce-sms-gf'); ?></span>
                        <span>{{vm.quepos}} / {{vm.countPhoneNumbers}}</span>
                        <span class="timeleft">({{vm.esitmatedMinutes}} <?= __("minutes", 'woocommerce-sms-gf')?>, {{vm.esitmatedSeconds}} <?= __("seconds", 'woocommerce-sms-gf') ?>)</span>
                        <div class="progress-bar">
                            <div class="inner">
                                <div class="line" ng-style="{'width' : (vm.quepos / vm.countPhoneNumbers) * 100 + '%' }">
                                    {{ vm.procentage }}%
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="completed" ng-show="vm.loopCompleted">
                        <h3><?= __('Message(s) sent!', 'woocommerce-sms-gf')?></h3>
                        <span><?= __("Number of credits used: ",'woocommerce-sms-gf')?> {{vm.usedCredits}}</span>
                        <div ng-click="vm.closeLoop()" class="btn btn-green">
                            <span><?=__('Close','woocommerce-sms-gf')?></span>
                        </div>
                    </div>
                </div>
            </div>
            <!-- END OF SECOND ROW -->
        </div>
    </form>
</div>

<!-- Start of grafikfabriken Zendesk Widget script -->
<script>/*<![CDATA[*/window.zEmbed||function(e,t){var n,o,d,i,s,a=[],r=document.createElement("iframe");window.zEmbed=function(){a.push(arguments)},window.zE=window.zE||window.zEmbed,r.src="javascript:false",r.title="",r.role="presentation",(r.frameElement||r).style.cssText="display: none",d=document.getElementsByTagName("script"),d=d[d.length-1],d.parentNode.insertBefore(r,d),i=r.contentWindow,s=i.document;try{o=s}catch(e){n=document.domain,r.src='javascript:var d=document.open();d.domain="'+n+'";void(0);',o=s}o.open()._l=function(){var e=this.createElement("script");n&&(this.domain=n),e.id="js-iframe-async",e.src="https://assets.zendesk.com/embeddable_framework/main.js",this.t=+new Date,this.zendeskHost="grafikfabriken.zendesk.com",this.zEQueue=a,this.body.appendChild(e)},o.write('<body onload="document._l();">'),o.close()}();
/*]]>*/</script>
<!-- End of grafikfabriken Zendesk Widget script -->
