<?php
/*
  Plugin Name: SMS for WooCommerce
  Plugin URI: https://smsfabriken.se/
  Description: Send text messages to your customers
  Version: 1.2.1
  Author: Grafikfabriken
  Tested: 4.7
  Requires: 4.7
  Author URI: https://grafikfabriken.nu
  Text Domain: woocommerce-sms-gf
  Domain Path: /lang/
  License: GPLv2 or later
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

global $wpdb;
global $woo_sms_gf_db_version;
$woo_sms_gf_db_version = '1.2.1';

if (!class_exists('woo_sms_gf')) {

    /**
     * Class woo_sms_gf
     * @version 1.0
     * @since 1.0
     * @author hampus alstermo<hampus@grafikfabriken.nu>
     */
    class woo_sms_gf {

        /**
         * Class instance
         *
         * @var woo_sms_gf
         */
        protected static $_instance = null;

        /**
         * Version number
         *
         * @var string
         */         
        public $version = "1.2.1";

        /**
         * Debug?
         *
         * @var boolean
         */     
        public static $debug = false;
        
        /**
         * Main gf Plugin Instance
         *
         * Ensures only one instance of gf Plugin is loaded or can be loaded.
         *
         * @static
         * @see gf()
         * @return gf Plugin - Main instance
         */
        public static function instance() {

            if (is_null(self::$_instance)) {
                self::$_instance = new self();
            }
            
            return self::$_instance;
        }

        /**
         * __construct function
         * @version 1.0
         * @since 1.0
         * @author hampus alstermo<hampus@grafikfabriken.nu>
         */
        public function __construct() {

            //define constants
            $this->define_constants();
            
            //do includes
            $this->includes();

            //adding some default acions
            $this->default_actions();

        }

        /**
         * Adding some default actions
         * @version 1.0
         * @since 1.0
         * @author hampus alstermo<hampus@grafikfabriken.nu>
         */
        public function default_actions() {
            add_action('admin_enqueue_scripts', array("woo_sms_gf_assets", "register_assets"));
            add_action('wp_enqueue_scripts', array("woo_sms_gf_assets", "register_assets"));
            add_action('init', array($this, "setup_text_domain"), 1);
        }

        /**
         * Setting up a text domain
         *
         * @return void
         * @author Hampus Alstermo <hampus@grafikfabriken.nu>
         * @version 1.0
         */
        public function setup_text_domain() {
            load_plugin_textdomain('woocommerce-sms-gf', false, WOO_SMS_GF_LANG_DIR);
        }

        /**
         * Define Constants
         * @version 1.0
         * @since 1.0
         * @author hampus alstermo<hampus@grafikfabriken.nu>
         */
        private function define_constants() {
            global $wpdb;

            //Setting variables
            $upload_dir = wp_upload_dir();

            if (!defined('WOO_SMS_GF_PLUGIN_FILE'))
                define('WOO_SMS_GF_PLUGIN_FILE', __FILE__);
            if (!defined('WOO_SMS_GF_PLUGIN_BASENAME'))
                define('WOO_SMS_GF_PLUGIN_BASENAME', plugin_basename(__FILE__));
            if (!defined('WOO_SMS_GF_PLUGIN_DIR'))
                define('WOO_SMS_GF_PLUGIN_DIR', dirname(__FILE__));
            if (!defined('WOO_SMS_GF_MAX_CHARS'))
                define('WOO_SMS_GF_MAX_CHARS', 160);
            if (!defined('WOO_SMS_GF_TEMPLATES_DIR'))
                define('WOO_SMS_GF_TEMPLATES_DIR', WOO_SMS_GF_PLUGIN_DIR . "/templates");
            if (!defined('WOO_SMS_GF_TEMPLATES_MAIL_DIR'))
                define('WOO_SMS_GF_TEMPLATES_MAIL_DIR', WOO_SMS_GF_TEMPLATES_DIR . "/mail");
            if (!defined('WOO_SMS_GF_TEMPLATES_PAGES_DIR'))
                define('WOO_SMS_GF_TEMPLATES_PAGES_DIR', WOO_SMS_GF_TEMPLATES_DIR . "/pages");
            if (!defined('WOO_SMS_GF_TEMPLATES_BLOCK_DIR'))
                define('WOO_SMS_GF_TEMPLATES_BLOCK_DIR', WOO_SMS_GF_TEMPLATES_DIR . "/blocks");
            if (!defined('WOO_SMS_GF_TEMPLATES_SHORTCODES_DIR'))
                define('WOO_SMS_GF_TEMPLATES_SHORTCODES_DIR', WOO_SMS_GF_TEMPLATES_DIR . "/shortcodes");
            if (!defined('WOO_SMS_GF_TEMPLATES_WIDGETS_DIR'))
                define('WOO_SMS_GF_TEMPLATES_WIDGETS_DIR', WOO_SMS_GF_TEMPLATES_DIR . "/widgets");
            if (!defined('WOO_SMS_GF_TEMPLATES_SLIDER_DIR'))
                define('WOO_SMS_GF_TEMPLATES_SLIDER_DIR', WOO_SMS_GF_TEMPLATES_DIR . "/slider");
            if (!defined('WOO_SMS_GF_TEMPLATES_WRAPPER_DIR'))
                define('WOO_SMS_GF_TEMPLATES_WRAPPER_DIR', WOO_SMS_GF_TEMPLATES_DIR . "/wrapper");
            if (!defined('WOO_SMS_GF_LIB_DIR'))
                define('WOO_SMS_GF_LIB_DIR', WOO_SMS_GF_PLUGIN_DIR . "/lib");
            if (!defined('WOO_SMS_GF_COMPOSER_DIR'))
                define('WOO_SMS_GF_COMPOSER_DIR', WOO_SMS_GF_PLUGIN_DIR . "/composer/vendor");
            if (!defined('WOO_SMS_GF_CLASSES_DIR'))
                define('WOO_SMS_GF_CLASSES_DIR', WOO_SMS_GF_LIB_DIR . "/classes");
            if (!defined('WOO_SMS_GF_PLUGIN_URL'))
                define('WOO_SMS_GF_PLUGIN_URL', plugins_url("", __FILE__));
            if (!defined('WOO_SMS_GF_SCRIPTS_URL'))
                define('WOO_SMS_GF_SCRIPTS_URL', WOO_SMS_GF_PLUGIN_URL . "/dist/scripts/");
            if (!defined('WOO_SMS_GF_STYLES_URL'))
                define('WOO_SMS_GF_STYLES_URL', WOO_SMS_GF_PLUGIN_URL . "/dist/styles/");
            if (!defined('WOO_SMS_GF_IMAGES_URL'))
                define('WOO_SMS_GF_IMAGES_URL', WOO_SMS_GF_PLUGIN_URL . "/dist/images/");
            if (!defined('WOO_SMS_GF_APP_DIR_URL'))
                define('WOO_SMS_GF_APP_DIR_URL', WOO_SMS_GF_PLUGIN_URL . "/templates/settings/");
            if (!defined('WOO_SMS_GF_VERSION'))
                define('WOO_SMS_GF_VERSION', $this->version);
            if (!defined('WOO_SMS_GF_DELIMITER'))
                define('WOO_SMS_GF_DELIMITER', '|');
            if (!defined('WOO_SMS_GF_LOG_DIR'))
                define('WOO_SMS_GF_LOG_DIR', $upload_dir['basedir'] . '/woo_sms_gf-logs/');
            if (!defined('WOO_SMS_GF_LANG_DIR'))
                define('WOO_SMS_GF_LANG_DIR', dirname(plugin_basename(__FILE__)) . "/lang");

            
        }

        /**
         * includes
         * @version 1.0
         * @since 1.0
         * @author hampus alstermo<hampus@grafikfabriken.nu>
         */
        private function includes() {
            include_once(WOO_SMS_GF_LIB_DIR . '/setup.php' );
        }

        /**
         * Activate woo_sms_gf plugin
         * @version 1.0
         * @since 1.0
         * @author hampus alstermo<hampus@grafikfabriken.nu>
         */
        public function activate() {

            // Check if woocommerce plugin exists
            if (!defined('WC_VERSION')) {
                require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
                deactivate_plugins(__FILE__);
                add_action('admin_notices',function(){
                    echo sprintf('<div id="message" class="updated error"><p>%s</p></div>',__('SMSFabriken requires WooCommerce 3.0.0 or higher.', 'woocommerce-sms-gf'));
                });
                return;
            }

            
            global $woo_sms_gf_db_version;
            
            //adding option for db version
            add_option('woo_sms_gf_db_version', $woo_sms_gf_db_version);

            //Add flushed option
            add_option("woo_sms_gf_has_flushed", false);
        }

        /**
         * Deactivate woo_sms_gf plugin
         * @version 1.0
         * @since 1.0
         * @author hampus alstermo<hampus@grafikfabriken.nu>
         */
        function deactivate() {
            update_option("woo_sms_gf_has_flushed", false);
        }

    }

    /**
     * Returns the main instance of woo_sms_gf to prevent the need to use globals.
     * @version 1.0
     * @since 1.0
     * @author hampus alstermo<hampus@grafikfabriken.nu>
     */
    function woo_sms_gf() {
        return woo_sms_gf::instance();
    }
    

    // Global for backwards compatibility.
    $GLOBALS['woo_sms_gf'] = woo_sms_gf();
    register_activation_hook(__FILE__, array($GLOBALS['woo_sms_gf'], 'activate'));
    register_deactivation_hook(__FILE__, array($GLOBALS['woo_sms_gf'], 'deactivate'));
    
}

